from sandbox.sandboxsdk import task
from sandbox.sandboxsdk import parameters
from sandbox.sandboxsdk import svn

from sandbox.projects import resource_types


class ArcadiaFlameGraphUrl(parameters.SandboxArcadiaUrlParameter):
    name = "arcadia_flame_graph_url"
    description = 'Arcadia url'
    default_value = svn.Arcadia.trunk_url("contrib/tools/flame-graph")
    required = True


class ArcadiaGprof2dotUrl(parameters.SandboxArcadiaUrlParameter):
    name = "arcadia_gprof2dot_url"
    description = 'Arcadia url'
    default_value = svn.Arcadia.trunk_url("contrib/tools/gprof2dot")
    required = True


class BuildFlameGraphBundle(task.SandboxTask):
    """Builds bundle with FlameGraph tools"""

    type = "BUILD_FLAME_GRAPH_BUNDLE"
    input_parameters = (
        ArcadiaFlameGraphUrl,
        ArcadiaGprof2dotUrl
    )

    def on_enqueue(self):
        task.SandboxTask.on_enqueue(self)
        self.create_resource(
            description=self.descr,
            resource_path=self.__gprof2dot_dir(),
            resource_type=resource_types.GPROF2DOT_BUNDLE,
        )
        self.create_resource(
            description=self.descr,
            resource_path=self.__flame_graph_dir(),
            resource_type=resource_types.FLAME_GRAPH_BUNDLE,
        )

    def on_execute(self):
        svn.Arcadia.export(self.ctx[ArcadiaFlameGraphUrl.name], self.__flame_graph_dir())
        svn.Arcadia.export(self.ctx[ArcadiaGprof2dotUrl.name], self.__gprof2dot_dir())

    def __flame_graph_dir(self):
        return self.abs_path("flame-graph")

    def __gprof2dot_dir(self):
        return self.abs_path("gprof2dot")


__Task__ = BuildFlameGraphBundle
