import os

from sandbox.sandboxsdk.task import SandboxTask
from sandbox.sandboxsdk.svn import Arcadia
from sandbox.sandboxsdk.parameters import SandboxArcadiaUrlParameter
from sandbox.projects import resource_types as rt
from sandbox.sandboxsdk.process import run_process


class BuildFreshnessScripts(SandboxTask):
    type = 'BUILD_FRESHNESS_SCRIPTS'

    class BaseUrl(SandboxArcadiaUrlParameter):
        name = 'base_url'

    input_parameters = [
        BaseUrl,
    ]

    def on_execute(self):
        base_url = self.ctx[self.BaseUrl.name]
        resource_root = 'out'

        os.mkdir(resource_root)

        Arcadia.export(
            Arcadia.append(base_url, '/yweb/freshness/scripts'),
            resource_root + '/freshness'
        )

        Arcadia.export(
            Arcadia.append(base_url, '/yweb/scripts/datascripts/common/mapreducelib.py'),
            resource_root
        )

        for file in ['ya_common.py', 'ya_corporate.py', 'ya_datetime.py']:
            Arcadia.export(
                Arcadia.append(
                    base_url,  # FIXME
                    '/yweb/scripts/datascripts/common/' + file),
                resource_root
            )

        resource_name = 'freshness-scripts.tar.gz'

        run_process(['tar', '-C', resource_root, '-zcf', resource_name, '.'])

        self.create_resource(
            '',
            resource_name,
            rt.FRESHNESS_SCRIPTS)


__Task__ = BuildFreshnessScripts
