# coding: utf-8


from sandbox.projects import resource_types
from sandbox.sandboxsdk.parameters import SandboxBoolParameter, SandboxSelectParameter
from sandbox.sandboxsdk.process import run_process
from sandbox.projects.common.build.BuildForAllTask import VersionParameter, DoNotRemoveResourcesParameter
import sandbox.projects.common.build.ScriptBuildTask as sbt


class GCCVersion(VersionParameter):
    description = 'GCC Version'
    default_value = '4.8.2'


class GCCUseSandboxGCC(sbt.UseSandboxGCCParameter):
    default_value = False


class LLD(SandboxBoolParameter):
    name = 'LLD'
    description = 'Provide LLD linker'


class TargetParam(SandboxSelectParameter):
    name = 'target'
    description = 'Cross compiler target'
    default_value = ''
    choices = (
        ('No cross compiler', ''),
        ('Darwin', 'x86_64-apple-darwin14'),
        ('ARM 64-bit', 'aarch64-linux'),
    )


class BuildGCC(sbt.ScriptBuildTask):
    type = 'BUILD_GCC'
    input_parameters = [GCCVersion, TargetParam, GCCUseSandboxGCC, LLD, DoNotRemoveResourcesParameter]
    execution_space = 16 * 1024

    # ScriptBuildTask fields
    tool_name = 'gcc'
    resource_type = resource_types.GCC_TOOLKIT

    def initCtx(self):
        self.ctx['kill_timeout'] = 6 * 60 * 60  # 6 hours

    def run_script(self, version, result_dir_path, env):
        args = ['/skynet/python/bin/python',
                self.abs_path('scripts/build_gcc.py'),
                '--version=%s' % version,
                '--logs=%s' % self.log_path(),
                result_dir_path]

        target = self.ctx.get(TargetParam.name)
        if target:
            args.append('--target=%s' % target)

        if self.ctx.get(LLD.name):
            args.append('--lld')

        run_process(args, shell=True, log_prefix='build', environment=env)


__Task__ = BuildGCC
