# coding: utf-8

from sandbox.projects import resource_types
from sandbox.projects.BuildGCC import BuildGCC
from sandbox.projects.common.build.BuildForAllTask import BuildForAllTask, PlatformsListParameter


class BuildGCCForAll(BuildForAllTask):
    type = 'BUILD_GCC_FOR_ALL'
    input_parameters = list(BuildGCC.input_parameters) + [PlatformsListParameter]
    release_to = 'sandbox-releases@yandex-team.ru'

    # BuildForAllTask fields
    subtask_type = BuildGCC
    subtask_description = 'Building GCC {version} toolkit for {target}'
    resource_type = resource_types.GCC_TOOLKIT
    resource_description = 'GCC {version} toolkit for {target}'


__Task__ = BuildGCCForAll
