# coding: utf-8


from sandbox.projects import resource_types
from sandbox.projects.common.build.BuildForAllTask import VersionParameter
import sandbox.projects.common.build.ScriptBuildTask as sbt
from sandbox.sandboxsdk.svn import Arcadia


class GDBVersion(VersionParameter):
    description = 'GDB Version'
    default_value = '7.6'


class BuildGDB(sbt.ScriptBuildTask):
    type = 'BUILD_GDB'
    input_parameters = [GDBVersion] + sbt.get_script_build_params()
    execution_space = 2 * 1024

    # ScriptBuildTask fields
    tool_name = 'gdb'
    resource_type = resource_types.GDB_TOOLKIT

    def run_script(self, version, result_dir_path, env, extra_params=None):
        if extra_params is None:
            extra_params = []

        extradir = self.abs_path('gdb-extra')
        Arcadia.export('svn+ssh://arcadia.yandex.ru/arc/trunk/arcadia/devtools/gdb', extradir)
        extra_params.append('--extra-dir={}'.format(extradir))

        sbt.ScriptBuildTask.run_script(self, version, result_dir_path, env, extra_params)


__Task__ = BuildGDB
