# coding: utf-8

from sandbox.projects import resource_types
from sandbox.projects.BuildGDB import BuildGDB
# noinspection PyProtectedMember
from sandbox.projects.common.build.BuildForAllTask import BuildForAllTask, PlatformsListParameter, LinuxPlatformParameter


class BuildGDBForAll(BuildForAllTask):
    type = 'BUILD_GDB_FOR_ALL'
    input_parameters = list(BuildGDB.input_parameters) + [PlatformsListParameter, LinuxPlatformParameter]
    release_to = 'sandbox-releases@yandex-team.ru'

    # BuildForAllTask fields
    subtask_type = BuildGDB
    subtask_description = 'Building GDB {version} toolkit for {target}'
    resource_type = resource_types.GDB_TOOLKIT
    resource_description = 'GDB {version} toolkit for {target}'
    bind_osx_host = False


__Task__ = BuildGDBForAll
