# -*- coding: utf-8 -*-
"""
    Task to build gencfg groups balancer config. Should be run in cycle in order to instantly generate new config with changes
"""

from sandbox.sandboxsdk.process import run_process

# auxiliarily gencfg stuff
from sandbox.projects import resource_types
from sandbox.projects.common.gencfg.task import IGencfgBuildTask


class BuildGGSConfig(IGencfgBuildTask):
    type = "BUILD_GGS_CONFIG"

    def get_ggs_file(self):
        return self.abs_path("ggs.cfg")

    def on_execute(self):
        self.clone_and_install_generator(precalc_caches=True, load_cache_resource=True)

        run_process(["/skynet/python/bin/python", "./custom_generators/balancer_gencfg/utils/generate_balancer_config.py", "-b", "ggs", "-t", "curdb", "-o", self.get_ggs_file()], work_dir=self.get_gencfg_path(), log_prefix='generate_ggs_config')
        self._create_resource("GGS balancer", self.get_ggs_file(), resource_types.BALANCER_GGS_CONFIG)


__Task__ = BuildGGSConfig
