# -*- coding: utf-8 -*-

import __builtin__

import os
import re

import sandbox.common.types.client as ctc

from sandbox.projects.common.build.BaseSimpleBuildTaskWithPkg import BaseSimpleBuildTaskWithPkg
import sandbox.projects.common.constants as consts

from sandbox.projects import resource_types
from sandbox.sandboxsdk.paths import get_logs_folder
from sandbox.sandboxsdk.svn import Arcadia
from sandbox.sandboxsdk import parameters


def target2field_name(target):
    return 'build_%s' % target


class BuildGemini(BaseSimpleBuildTaskWithPkg):
    type = 'BUILD_GEMINI'

    client_tags = ctc.Tag.LINUX_PRECISE

    TARGET_RESOURCES = (
        (resource_types.GEMINICL, 'robot/gemini/client2/geminicl'),
        (resource_types.MR_GEMINICL, 'robot/gemini/mr/client2/mr_geminicl'),
    )

    RESOURCE_TO_PKG_MAP = {
        'linux': {
            'GEMINICL': 'packages/debian/gemini/yandex-search-gemini-client',
        },
    }

    class GeminiBlock(parameters.SandboxInfoParameter):
        name = 'gemini_block'
        description = 'Gemini Binaries'

    input_parameters = BaseSimpleBuildTaskWithPkg.input_parameters + [GeminiBlock]
    for _, path in TARGET_RESOURCES:
        target = os.path.basename(path)
        field_name = target2field_name(target)
        input_parameters.extend([__builtin__.type(
            field_name,
            (parameters.SandboxBoolParameter,),
            dict(name=field_name, description=target),
        )])

    def on_execute(self):

        if self.do_pkg_tasks_exist():
            self.check_pkg_tasks()
            return

        self.ctx[consts.ARCADIA_URL_KEY] = self.normalize_svn_url(self.ctx[consts.ARCADIA_URL_KEY])

        os.putenv('LD_LIBRARY_PATH', '')
        BaseSimpleBuildTaskWithPkg.on_execute(self)

        log_path = get_logs_folder()
        out_str = ''
        if(self.ctx['build_geminicl']): out_str += ',"geminicl_resource_id":"%s"' % list(self.list_resources('GEMINICL'))[0].id
        if(self.ctx['build_mr_geminicl']): out_str += ',"mr_geminicl_resource_id":"%s"' % list(self.list_resources('MR_GEMINICL'))[0].id

        open(os.path.join(log_path, 'gemini.id.out.txt'), "w").write(out_str)

        if self.are_pkgs_enabled():
            self.mark_resources_ready()
            self.create_pkg_tasks()

    @staticmethod
    def normalize_svn_url(svn_url):
        path = Arcadia.parse_url(svn_url).path
        svn_path = re.sub(r'/arcadia.*', '/arcadia', path, count=1)
        return Arcadia.replace(svn_url, path=svn_path)


__Task__ = BuildGemini
