# -*- coding: utf-8 -*-

import sandbox.common.types.client as ctc

from sandbox.projects.common import utils
import sandbox.projects.common.constants as consts
from sandbox.projects.common.nanny import nanny
from sandbox.projects.BuildSearch import BuildSearch
from sandbox.projects.release_machine import rm_notify


@rm_notify.notify2()
class BuildGeosearch(nanny.ReleaseToNannyTask, BuildSearch):
    type = 'BUILD_GEOSEARCH'

    input_parameters = [nanny.StartrekTicketIdsParameter] + BuildSearch.input_parameters

    client_tags = ctc.Tag.Group.LINUX

    def arcadia_info(self):
        rev = utils.svn_revision(self.ctx.get(consts.ARCADIA_URL_KEY, '')) or "UNKNOWN REVISION"
        return None, 'ADDRS metasearch build r{}'.format(rev), None


__Task__ = BuildGeosearch
