# coding: utf-8
import sandbox.common.types.misc as ctm
import sandbox.common.types.client as ctc

from sandbox.projects.common import utils
from sandbox.projects.common.nanny import nanny
from sandbox.projects.nanny.common.environments import GoDistEnvironment
from sandbox.projects.resource_types import nanny_releasers, AbstractResource
from sandbox.sandboxsdk import parameters
from sandbox.sandboxsdk.process import run_process
from sandbox.sandboxsdk.task import SandboxTask


class COMPILED_GO_PACKAGE(AbstractResource):
    """
        BuildGoPackage result
    """
    releasable = True
    any_arch = False
    executable = True
    auto_backup = True
    releasers = nanny_releasers


class PackageParameter(parameters.SandboxStringParameter):
    name = 'package'
    description = 'Package to build'
    default_value = 'bb.yandex-team.ru/NANNY/gobabygo'
    required = True


class BuildGoPackage(nanny.ReleaseToNannyTask, SandboxTask):
    type = 'BUILD_GO_PACKAGE'
    dns = ctm.DnsType.DNS64  # github doesn't support ipv6 at the moment
    client_tags = ctc.Tag.LINUX_PRECISE
    input_parameters = [PackageParameter]
    environment = (
        GoDistEnvironment('1.14'),
    )

    def _make_resource(self, resource_path, description=''):
        self.create_resource(
            description=description,
            resource_path=resource_path,
            resource_type=COMPILED_GO_PACKAGE,
            arch='linux'
        )

    def on_execute(self):
        package_to_build = utils.get_or_default(self.ctx, PackageParameter)
        build_bin = self.path(package_to_build.rsplit('/', 1)[1])
        if package_to_build.startswith(('git.qe-infra.yandex-team.ru', 'bb.yandex-team.ru')):
            oauth_token = self.get_vault_data('GBG', 'nanny_robot_bb_oauth_token')
            run_process(['git', 'config', '--global',
                         'url.https://x-oauth-token:' + oauth_token + '@bb.yandex-team.ru/.insteadOf',
                         'https://bb.yandex-team.ru/'])
            run_process(['go', 'get', package_to_build],
                        log_prefix='go get',
                        shell=True)
        else:
            run_process(['go', 'get', package_to_build],
                        log_prefix='go get',
                        shell=True)
        run_process(['go', 'build', '-o', build_bin, package_to_build],
                    log_prefix='go build',
                    shell=True)
        self._make_resource(build_bin, description=package_to_build)


__Task__ = BuildGoPackage
