# -*- coding: utf-8 -*-

import os
import shutil

from sandbox.projects import resource_types
from sandbox.projects.common.build.YaMake import YaMakeTask, BUILD_DIR


class BuildMarketGuru(YaMakeTask):
    type = 'BUILD_MARKET_GURU_BIN'

    execution_space = 100 * 1024  # 100 GB

    input_parameters = [p for p in YaMakeTask.input_parameters if p.name not in ['targets']]

    def initCtx(self):
        self.ctx['fail_on_any_error'] = True

    @property
    def targets_description(self):
        return [
            ('market/gurudaemon/bin/offline_guru/offline_guru', 'guru', resource_types.MARKET_GURU_BIN, 'market/gurudaemon'),
            ('market/gurudaemon/bin/guru_daemon/guru_daemon-bin', 'guru_online', resource_types.MARKET_GURU_BIN_ONLINE, 'market/gurudaemon'),
        ]

    def export_build_resources(self):
        src_path = BUILD_DIR

        for res in self.targets_description:
            res_path, filename, res_type, _ = res
            to_path = self.abs_path(filename)
            from_path = os.path.join(src_path, res_path)
            if os.path.isdir(from_path):
                shutil.copytree(from_path, to_path)
            else:
                shutil.copy(from_path, to_path)
            self.create_resource(filename, to_path, res_type)

    def do_execute(self):
        YaMakeTask.do_execute(self)
        self.export_build_resources()

    def get_targets(self):
        return [res[3] for res in self.targets_description]


__Task__ = BuildMarketGuru
