# coding: utf-8


from sandbox.projects import resource_types
from sandbox.projects.common.build.BuildForAllTask import VersionParameter
import sandbox.projects.common.build.ScriptBuildTask as sbt


class HGVersion(VersionParameter):
    description = 'Mercurial version'
    default_value = '3.6.1'


class BuildHG(sbt.ScriptBuildTask):
    type = 'BUILD_HG'
    input_parameters = [HGVersion] + sbt.get_script_build_params()
    execution_space = 2 * 1024

    # ScriptBuildTask fields
    tool_name = 'hg'
    resource_type = resource_types.HG_TOOLKIT


__Task__ = BuildHG
