# coding: utf-8

from sandbox.projects import resource_types
from sandbox.projects.BuildHG import BuildHG
from sandbox.projects.common.build.BuildForAllTask import BuildForAllTask, PlatformsListParameter


class BuildHGForAll(BuildForAllTask):
    type = 'BUILD_HG_FOR_ALL'
    input_parameters = list(BuildHG.input_parameters) + [PlatformsListParameter]
    release_to = 'sandbox-releases@yandex-team.ru'

    # BuildForAllTask fields
    subtask_type = BuildHG
    subtask_description = 'Building Mercurial {version} toolkit for {target}'
    resource_type = resource_types.HG_TOOLKIT
    resource_description = 'Mercurial {version} toolkit for {target}'


__Task__ = BuildHGForAll
