from sandbox import sdk2
import tarfile
from sandbox.projects.common.nanny import nanny


class HighlanderDataFull(sdk2.Resource):
    releasers = ['marchhare', 'ekilimchuk']
    releasable = True

    svn_info = sdk2.parameters.String
    revision_id = sdk2.parameters.String


class BuildHighlanderDataFull(nanny.ReleaseToNannyTask2, sdk2.Task):
    """Builds full data bundle from Arcadia"""

    class Parameters(sdk2.Parameters):
        with sdk2.parameters.Group("Subversion Parameters") as subversion_block:
            resources_url = sdk2.parameters.ArcadiaUrl('Path to resources in Arcadia',
                                            default_value='arcadia:/robots/trunk/genconf/resources', required=True)
            revision_id = sdk2.parameters.String('Revision ID', required=False)

    def on_execute(self):

        revid = str(self.Parameters.revision_id)
        svn_info = dict(sdk2.svn.Arcadia.info(self.Parameters.resources_url))

        if not revid.isdigit():
            revid = svn_info['commit_revision']

        sdk2.svn.Arcadia.export(self.Parameters.resources_url, 'res', revision=revid)

        resource_data = sdk2.ResourceData(HighlanderDataFull(self, 'Full resources export at rev:{}'.format(revid),
                                                             'res.tar.gz', svn_info=str(svn_info), revision_id=revid))

        with tarfile.open(str(resource_data.path), 'w:gz') as tar:
            tar.add('res')
        resource_data.ready()
