from sandbox import sdk2
import tarfile
import os
import errno
from sandbox.projects.common.nanny import nanny


class HighlanderDataUpdate(sdk2.Resource):
    releasers = ['marchhare', 'ekilimchuk']
    releasable = True

    revision_to = sdk2.parameters.String
    revision_from = sdk2.parameters.String


class BuildHighlanderDataUpdate(nanny.ReleaseToNannyTask2, sdk2.Task):
    """Builds full data tar from Arcadia"""

    class Parameters(sdk2.Parameters):
        with sdk2.parameters.Group("Subversion Parameters") as subversion_block:
            resources_url = sdk2.parameters.ArcadiaUrl('Path to resources in Arcadia',
                                                       default_value='arcadia:/robots/trunk/genconf/resources',
                                                       required=True)
            rev_id_from = sdk2.parameters.String('Revision ID From', required=False)
            rev_id_to = sdk2.parameters.String('Revision ID To', required=False)

    def on_execute(self):
        log = sdk2.svn.Arcadia.log(self.Parameters.resources_url,
                                   self.Parameters.rev_id_from, self.Parameters.rev_id_to)
        resource_data = sdk2.ResourceData(HighlanderDataUpdate(self, 'data update from {} to {}'.format(
            self.Parameters.rev_id_from, self.Parameters.rev_id_to), 'res_update.tar.gz',
                                                               revision_from=str(self.Parameters.rev_id_from),
                                                               revision_to=str(self.Parameters.rev_id_to)))
        file_list = list()
        for item in log:
            for p in item['paths']:
                if p[0] != 'D':
                    file_list.append(p[1])
        for file in file_list:
            if not os.path.exists(os.path.dirname('.{}'.format(file))):
                try:
                    os.makedirs(os.path.dirname('.{}'.format(file)))
                except OSError as exc:  # Guard against race condition
                    if exc.errno != errno.EEXIST:
                        raise
            with open('.{}'.format(file), 'w') as f:
                f.write(sdk2.svn.Arcadia.cat('arcadia:robots{}'.format(file), revision=self.Parameters.rev_id_to))
        with tarfile.open(str(resource_data.path), 'w:gz') as tar:
            tar.add('trunk')

        resource_data.ready()
