# -*- coding: utf-8 -*-

import os
import tarfile

from sandbox.projects import resource_types
from sandbox.projects.common.build.CommonBuildTask import CommonBuildTask
from sandbox.projects.common import utils

import sandbox.projects.common.constants as consts


class BuildIcookieDaemon(CommonBuildTask):
    """
        Build balancer binary
    """
    type = 'BUILD_ICOOKIE_DAEMON'

    TARGET_RESOURCES = (
        (resource_types.ICOOKIE_DAEMON_EXECUTABLE, 'yweb/webdaemons/icookiedaemon/icookiedaemon'),
    )

    def arcadia_info(self):
        rev = utils.svn_revision(self.ctx.get(consts.ARCADIA_URL_KEY, '')) or "UNKNOWN REVISION"
        return rev, "icookie daemon r" + rev, "trunk"

    def on_execute(self):
        CommonBuildTask.on_execute(self)

        path_tgz = self.path("icookiedaemon.tar.gz")

        with tarfile.open(path_tgz, "w:gz") as tar:
            tar.dereference = True
            tar.add(self.abs_path(os.path.join(self.LOCAL_RELEASE_DIR, "yweb/webdaemons/icookiedaemon/icookiedaemon")), "icookiedaemon")
            tar.add(self.abs_path(os.path.join(self.get_arcadia_src_dir("arcadia:/arc/trunk/arcadia/yweb/webdaemons/icookiedaemon/icookie_lib"), "keys.txt")), "keys.txt")

        self.create_resource(
                description="icookiedaemon tgz r{}".format(self.arcadia_info()[0]),
                resource_path=path_tgz,
                resource_type=resource_types.ICOOKIE_DAEMON_ARCHIVE,
                arch='linux'
        )


__Task__ = BuildIcookieDaemon
