# -*- coding: utf-8 -*-

import os

from sandbox.projects import resource_types
from sandbox.projects.common.build.CommonBuildTask import CommonBuildTask
from sandbox.sandboxsdk.paths import copy_path


class BuildImageParserRaw(CommonBuildTask):
    """
        build imageparserlib-raw - imageparser lib with nonarcadia interface
    """

    type = 'BUILD_IMAGEPARSER_RAW'

    TARGET_RESOURCES = (
        (resource_types.CV_RAW_COCAINE_LIBRARY, 'cv/library/imageparserlib/rawinterface/dynamic/libimageparser-raw.so'),
    )

    execution_space = 20000

    HEADERS_DIR = 'inc'

    def do_execute(self):
        arcadia_src_dir = self.get_arcadia_src_dir()
        # arcadia_data_dir = self.fetch_test_data('arcadia_tests_data/images')

        headers_path = os.path.join(arcadia_src_dir, 'cv', 'library', 'imageparserlib', 'rawinterface', 'inc')
        copy_path(headers_path, self.HEADERS_DIR)
        self.create_resource('inc', self.HEADERS_DIR, resource_types.CV_RAW_COCAINE_HEADERS)

        CommonBuildTask.do_execute(self)


__Task__ = BuildImageParserRaw
