# -*- coding: utf-8 -*-

from sandbox.projects import resource_types
from sandbox.projects.images import resource_types as images_resource_types
from sandbox.projects.common.mediasearch.build import BaseMediaBuildTask
import sandbox.projects.common.constants as consts


class BuildImagesFactorsBundle(BaseMediaBuildTask):
    """
        Бинарники для построения пользовательских факторов
    """

    type = 'BUILD_IMAGES_FACTORS_BUNDLE'
    execution_space = 102400

    def initCtx(self):
        self.ctx[consts.BUILD_BUNDLE_KEY] = False
        self.ctx[consts.THINLTO] = True
        self.ctx[consts.BUILD_SYSTEM_KEY] = consts.SEMI_DISTBUILD_BUILD_SYSTEM

    def get_binaries(self):
        return (
            resource_types.IMAGES_FACTORS_USERFACTORS,
            resource_types.IMAGES_FACTORS_ANNDATA,
            resource_types.IMAGES_FACTORS_CLICKSIM,
            resource_types.IMAGES_FACTORS_STREAMS,
            resource_types.IMAGES_FACTORS_HOSTFACTORS,
            resource_types.IMAGES_FACTORS_PAGEFACTORS,
            resource_types.IMAGES_FACTORS_TOLOKA_TOP_REQUESTS,
            resource_types.IMAGES_FACTORS_MOBILENESS,
            resource_types.IMAGES_FACTORS_BIGTHUMBS,
            resource_types.IMAGES_DOWNLOAD_RESOURCE_EXECUTABLE,
            images_resource_types.IMAGES_FACTORS_CLEAN_STATES,
            images_resource_types.IMAGES_RELEASE_RESOURCES_EXECUTABLE,
        )


__Task__ = BuildImagesFactorsBundle
