# -*- coding: utf-8 -*-

from sandbox.projects import resource_types
from sandbox.projects.common.mediasearch.build import BaseMediaBuildTask
import sandbox.projects.common.constants as consts
import logging


class BuildImagesFastMrIndexBundle(BaseMediaBuildTask):
    """
        Бинарники для построения быстрого индекса на MR
    """

    type = "BUILD_IMAGES_FAST_MR_INDEX_BUNDLE"
    execution_space = 60000

    def initCtx(self):
        self.ctx[consts.BUILD_BUNDLE_KEY] = False
        self.ctx['ckeck_if_initctx_working'] = 'working'

    def get_branch_overrides(self, branch):
        hacks4 = {
            'cv/sigtools/nnindexer/nnindexer': 'yweb/images/sigtools/nnindexer/nnindexer',
        }
        logging.info("branch %s" % branch)
        if branch in ('images/mrindexer/stable-4-1',
                      'images/mrindexer/stable-4-2',
                      'images/mrindexer/pre-stable-4'
                      ):
            logging.info("using relocations hack4")
            return hacks4
        return {}

    def get_binaries(self):
        return (
            resource_types.IMAGES_MR_INDEX_DOCID_VIEWER,
            resource_types.IMAGES_MR_INDEX_INDEXBUILDER,
            resource_types.IMAGES_XDELTA,
            resource_types.IMAGES_MR_INDEX_INPUT,
            resource_types.IMAGES_MR_INDEX_INPUTDOC,
            resource_types.IMAGES_MR_INDEX_METADOC,
            resource_types.IMAGES_MR_INDEX_DOCCOUNTER,
            resource_types.IMAGES_MR_INDEX_NNINDEXER,
            resource_types.IMAGES_MR_INDEX_COPYDOCATTRS,
            resource_types.IMAGES_MR_INDEX_SEMIDUPS,
            resource_types.IMAGES_MR_INDEX_PLANNER,
            resource_types.IMAGES_MR_INDEX_REMAPINDEX,
            resource_types.IMAGES_MR_INDEX_SELECTIONRANK,
            resource_types.IMAGES_MR_INDEX_SHARDWRITER,
            resource_types.IMAGES_MR_INDEX_STATISTICS,
            resource_types.IMAGES_MR_INDEX_TRACEROUTE,
            resource_types.IMAGES_MR_INDEX_CBIR,
            resource_types.IMAGES_MR_INDEX_IMGTRIEBUILDER,
            resource_types.IMAGES_MR_INDEX_IDXTHUMB,
            resource_types.IMAGES_MR_INDEX_THDB,
            resource_types.IMAGES_MR_INDEX_EXPORT2UKROP,
            resource_types.IMAGES_MR_INDEX_FEEDBACK,
            resource_types.IMAGES_MR_INDEX_RATEDINDEX,
            resource_types.IMAGES_MR_INDEX_IDXCONVERT,
            resource_types.IMAGES_MR_INDEX_USERDOC,
            resource_types.IMAGES_MR_INDEX_USERTRIE,
            resource_types.IMAGES_MR_INDEX_PORNOBAN,
            resource_types.IMAGES_MR_INDEX_CLEANUP,
            resource_types.IMAGES_MR_INDEX_CBIR_INDEXER,
            resource_types.SHARDTOOL,
        )

    def get_configs(self):
        return (
            resource_types.IMAGES_MR_INDEX_STATISTICS_PRETTY_PRINT,
            resource_types.SHARDTOOL_CONFIG,
            resource_types.IMAGES_FAST_INDEX_SHARD_BUILDER,
            resource_types.IMAGES_FAST_CBIR_SHARD_BUILDER,
            resource_types.IMAGES_FAST_IMTUB_SHARD_BUILDER,
            resource_types.IMAGES_FAST_IMTUB_INSTALL_SCRIPT,
        )


__Task__ = BuildImagesFastMrIndexBundle
