# -*- coding: utf-8 -*-

from sandbox.projects import resource_types
from sandbox.projects.common.mediasearch.build import BaseMediaBuildTask
import sandbox.projects.common.constants as consts


class BuildImagesTagsBundle(BaseMediaBuildTask):
    """
        Бинарники для построения индекса тегов
    """

    type = 'BUILD_IMAGES_TAGS_BUNDLE'
    execution_space = 20000

    def initCtx(self):
        self.ctx[consts.BUILD_BUNDLE_KEY] = False

    def get_binaries(self):
        return (
            resource_types.IMAGES_TAGS_BUILD_MAIN,
            resource_types.IMAGES_TAGS_BUILD_HOMONYMS,
            resource_types.IMAGES_TAGS_BUILD_GZT
        )

    def get_configs(self):
        return (
            resource_types.IMAGES_TAGS_FILTER_STOPWORDS
        )


__Task__ = BuildImagesTagsBundle
