# -*- coding: utf-8 -*-

from sandbox.projects import resource_types
from sandbox.projects.common.mediasearch.build import BaseMediaBuildTask
import sandbox.projects.common.constants as consts


class BuildImagesUserdbBundle(BaseMediaBuildTask):
    """
        Бинарники для парсинга пользовательских данных
    """

    type = "BUILD_IMAGES_USERDB_BUNDLE"
    execution_space = 30000

    def initCtx(self):
        self.ctx[consts.BUILD_BUNDLE_KEY] = False

    def get_binaries(self):
        return (
            resource_types.IMAGES_USERDB_USERSESSIONS,
            resource_types.IMAGES_USERDB_MERGESTATE,
            resource_types.IMAGES_USERDB_FASTLOGSPARSER,
            resource_types.IMAGES_USERDATA_STATISTICS,
            resource_types.IMAGES_USERDATA_CONVERTER
        )


__Task__ = BuildImagesUserdbBundle
