# coding: utf-8
import os

from sandbox.common.types.client import Tag
from sandbox.sandboxsdk.process import run_process

from sandbox.projects.common.build.YaMake import YaMakeTask


class BuildInstanceCtlBinary(YaMakeTask):

    type = 'BUILD_INSTANCECTL_BINARY'

    INSTANCE_CTL_PROJECT_PATH = 'infra/nanny/instancectl'

    client_tags = Tag.PORTOD

    execution_space = 40 * 1024

    cores = 24

    @property
    def privileged(self):
        return True

    def _set_version(self, sources_path):
        version_file_path = os.path.join('src', 'instancectl', 'version.py')
        run_process(['sed', '-i',
                     '"s/development_version/$(/skynet/python/bin/python setup.py --version)/g"', version_file_path],
                    shell=True, log_prefix='set_version',
                    work_dir=sources_path)

    def pre_build(self, source_dir):
        path = os.path.join(source_dir, self.INSTANCE_CTL_PROJECT_PATH)
        self._set_version(path)


__Task__ = BuildInstanceCtlBinary
