# coding: utf-8
from sandbox.projects import resource_types
from sandbox.projects.common.iss.BuildFromArtifactoryTask import BuildFromArtifactoryTask, create_version_parameter

ARTIFACT_DIR = 'http://artifactory.yandex.net/artifactory/qe/ru/yandex/iss/iss-cacher-uber-jar/'


class BuildIssCacher(BuildFromArtifactoryTask):
    """
        Get cacher jar from maven, make it a resource and register in nanny on release
    """
    type = 'BUILD_ISS_CACHER'

    input_parameters = [
        create_version_parameter(ARTIFACT_DIR, 'Cacher artifact version (uber jar)')
    ]

    def _resource_path(self):
        return "iss-cacher.jar"

    def _artifact_dir(self):
        return ARTIFACT_DIR

    def _artifact_basename_template(self):
        return "iss-cacher-uber-jar-{version}.jar"

    def _resource_type(self):
        return resource_types.ISS_CACHER_PRESTABLE

    def _resource_id_context_key(self):
        return 'cacher_jar_id'


__Task__ = BuildIssCacher
