# coding: utf-8
from sandbox.projects import resource_types
from sandbox.projects.common.iss.BuildFromArtifactoryTask import BuildFromArtifactoryTask, create_version_parameter


ARTIFACT_DIR = 'http://artifactory.yandex.net/artifactory/qe/ru/yandex/capper/capper-uber-jar/'


class BuildIssCapper(BuildFromArtifactoryTask):
    """
        Get capper jar from maven, make it a resource and register in nanny on release
    """
    type = 'BUILD_ISS_CAPPER'

    input_parameters = [
        create_version_parameter(ARTIFACT_DIR, 'Capper artifact version (uber jar)')
    ]

    def _resource_path(self):
        return "capper.jar"

    def _artifact_dir(self):
        return ARTIFACT_DIR

    def _artifact_basename_template(self):
        return "capper-uber-jar-{version}.jar"

    def _resource_type(self):
        return resource_types.ISS_CAPPER_JAR

    def _resource_id_context_key(self):
        return 'capper_jar_id'


__Task__ = BuildIssCapper
