# -*- coding: utf-8 -*-

from sandbox import sdk2

import sandbox.projects.resource_types.releasers as resource_releasers


class IznankaUrlsExtractorExecutable(sdk2.Resource):
    """
        Тулза, которая дампит в stdout или файл все урлы организаций, доступные в "изнанке"
    """
    releasable = True
    executable = True
    releasers = resource_releasers.geosearch_releasers
    arcadia_build_path = 'search/geo/tools/iznanka/get_company_urls'


class IznankaCompanyUrlsTsv(sdk2.Resource):
    """
        Файл в формате url \\t type со всеми урлами организаций, доступными в изнанке. Является исходником для ресурca
        IznankaCompanyUrlsTrie
    """
    releasable = True
    releasers = resource_releasers.geosearch_releasers


class IznankaCompanyUrlsTrie(sdk2.Resource):
    """
        Trie с урлами компаний, доступными в "изнанке"
    """
    releasable = True
    releasers = resource_releasers.geosearch_releasers
    auto_backup = True
