import os

from sandbox.projects import resource_types
from sandbox.projects.common.build.parameters import get_arcadia_params
from sandbox.projects.common.build.YaMake import YaMakeTask, ya_make_build_params


class BuildJupiterTool(YaMakeTask):
    """
        The tool for building shards from YT in the runtime cloud.
    """
    type = 'BUILD_JUPITERTOOL'
    input_parameters = ya_make_build_params() + get_arcadia_params()

    def get_resources(self):
        resources = {
            'description': 'Build executable',
            'resource_path': os.path.basename(resource_types.JUPITERTOOL.arcadia_build_path),
            'resource_type': resource_types.JUPITERTOOL,
        }
        return {'project': resources}

    def get_targets(self):
        return [resource_types.JUPITERTOOL.arcadia_build_path]

    def get_arts(self):
        return [{'path': resource_types.JUPITERTOOL.arcadia_build_path}]


__Task__ = BuildJupiterTool
