# -*- coding: utf-8 -*-

import os
import platform

from sandbox.projects import resource_types
from sandbox.sandboxsdk.process import run_process
from sandbox.projects.common.build.CommonBuildTask import CommonBuildTask
from sandbox.projects.common.build.BuildForAllTask import DoNotRemoveResourcesParameter


class BuildKWMKTorrent(CommonBuildTask):
    """Class for building KiWi make-torrent utility.
    """

    type = 'BUILD_KWMKTORRENT'

    TARGET_RESOURCES = (
        (
            resource_types.KWMKTORRENT,
            'yweb/robot/kiwi/kwmktorrent/kwmktorrent'
        ),
    )

    def do_execute(self):
        CommonBuildTask.do_execute(self)

        kwmktorrent_dir = self.abs_path(os.path.join(self.LOCAL_RELEASE_DIR,
                                                     'yweb/robot/kiwi/kwmktorrent'))
        run_process(['tar', '-czf', self.abs_path('kwmktorrent.tgz'),
                     'kwmktorrent'],
                    shell=True, log_prefix='tar', work_dir=kwmktorrent_dir)

        attrs = {'platform': platform.platform()}
        if self.ctx.get(DoNotRemoveResourcesParameter.name):
            attrs['ttl'] = 'inf'

        target = self.ctx.get('target_platform_alias', platform.platform())

        self.create_resource(
            description='KWMKTorrent archive for {target}'.format(target=target),
            resource_path=self.abs_path('kwmktorrent.tgz'),
            resource_type=resource_types.KWMKTORRENT_ARCHIVE,
            attributes=attrs
        )


__Task__ = BuildKWMKTorrent
