# -*- coding: utf-8 -*-

import os
import platform

from sandbox.projects import resource_types
from sandbox.sandboxsdk.process import run_process
from sandbox.projects.common.build.CommonBuildTask import CommonBuildTask
from sandbox.projects.common.build.BuildForAllTask import DoNotRemoveResourcesParameter


class BuildKWMQBuild(CommonBuildTask):
    """Class for building KiWi metaquery translator.
    """

    type = 'BUILD_KWMQBUILD'

    TARGET_RESOURCES = (
        (
            resource_types.KWMQBUILD,
            'yweb/robot/kiwi/kwmqbuild/kwmqbuild'
        ),
    )

    def do_execute(self):
        CommonBuildTask.do_execute(self)

        kwmqbuild_dir = self.abs_path(os.path.join(self.LOCAL_RELEASE_DIR,
                                                   'yweb/robot/kiwi/kwmqbuild'))
        run_process(['tar', '-czf', self.abs_path('kwmqbuild.tgz'),
                     'kwmqbuild'],
                    shell=True, log_prefix='tar', work_dir=kwmqbuild_dir)

        attrs = {'platform': platform.platform()}
        if self.ctx.get(DoNotRemoveResourcesParameter.name):
            attrs['ttl'] = 'inf'

        target = self.ctx.get('target_platform_alias', platform.platform())

        self.create_resource(
            description='KWMQBuild archive for {target}'.format(target=target),
            resource_path=self.abs_path('kwmqbuild.tgz'),
            resource_type=resource_types.KWMQBUILD_ARCHIVE,
            attributes=attrs
        )


__Task__ = BuildKWMQBuild
