"""Constant options which may be used by many modules.
"""

TRUNK_SVN_ROOT = 'arcadia:/arc/trunk/arcadia'

DEFAULT_TRIGGERS_SVN_PATH = 'yweb/robot/kiwi_queries'
DEFAULT_TRIGGERS_SVN_META_PATH = 'yweb/robot/kiwi_queries/robot/packages/main'

TRIGGER_CTX_PREFIX = 't_'

# File in triggers' directories in svn.
# WARNING: Templates and generated files have now the same names but they are
#          different files and either of them may be renamed in the future.
MQ_META_TPL = 'deploy.mq'
PB_META_FILE = 'metadata.pb.txt'

# String used instead of real branch name in templates.
TPL_BRANCH_STR = 'trunk'

EXPORTS_ADD_FILE = 'exports.add'
EXPORTS_LST_FILE = 'exports.lst'
PROCEDURES_LST_FILE = 'procedures.lst'

EXPORTS_MQ_LST_FILE = 'exports.mq.lst'
PROCEDURES_MQ_LST_FILE = 'procedures.mq.lst'

QUERIES_SVN_PATH = 'yweb/robot/kiwi_queries'
QUERY_SFX = '.query'
CONDITION_SFX = '.condition'

DEPLOY_DIR = 'deploy'

# Generated files
MQ_META_FILE = 'deploy.mq'          # ``mq'' stands for Meta Query
MQ_PROC_FILE = 'procedures.mq'
MQ_ENABLE_FILE = 'enable.mq'
MQ_RELEASE_FILE = 'release.mq'

# Generated trigger's meta files that shold not be added to AddUdf messages.
NON_DEPLOYABLE_FILES = [MQ_META_FILE, MQ_ENABLE_FILE, PB_META_FILE]

TASKINFO_FILE_NAME = 'sandbox-task-info'
