"""Dictionary for setting sources for triggers' data files.

The dictionary should be kept updated according to
http://wiki.yandex-team.ru/robot/czech/fakeprewalrusfiles/files."""

from sandbox.projects import resource_types as rt
from sandbox.projects.BuildKiwiTriggers.data_scheme import sandbox_url, Scheme


# Widely used Sandbox resources.
ANTISPAM_RULES = sandbox_url(rt.ANTISPAM_KIWI_RULES, '/')
ANTISYN = sandbox_url(rt.WALRUS_TPL_ANTISYN, '/')
BAD_WORDS_WEIGHTS = sandbox_url(rt.WALRUS_TPL_BAD_WORDS_WEIGHTS,
                                '/bad_words_weights.txt')
FORCES_INFO = sandbox_url(rt.WALRUS_TPL_FORCES_INFO, '/forces_info')
PURE_TRIE = sandbox_url(rt.WALRUS_TPL_PURE_TRIE, '/pure.trie')
SEOLNK = sandbox_url(rt.WALRUS_TPL_SEOLNK, '/seolnk')
SHOP = sandbox_url(rt.WALRUS_TPL_SHOP, '/')
WORD_WHT_TRIE = sandbox_url(rt.WORD_WHT_TRIE)
YA_CATALOG_DATA = sandbox_url(rt.YA_CATALOG_DATA, '/')
YA_DATABASE_GOOGLE_DATA = sandbox_url(rt.YA_DATABASE_GOOGLE_DATA, '/')

# Widely used prefixes.
ARC_DATA_ROOT = Scheme.SVN_BRANCH_ROOT + '://data/'
ARC_TESTS_DATA_ROOT = Scheme.SVN_BRANCH_ROOT + '://arcadia_tests_data/'
ARC_WC_ROOT = Scheme.WC_FILE + '://arcadia/'
YA_BERKANAVT = Scheme.RSYNC + '://ya.fb.yandex.ru/berkanavt_sandbox/'

SHARED_DATA_DIR = '../../shared_data'

antispam_tpl = {
    'files': [
        {'src': ANTISPAM_RULES, },
    ],
}

triggers_datapaths = {
    # Udfs.Name from metadata-files are used as keys.
}

triggers_data = {
    # Directory names from triggers_svn_path are used as keys.
    # If ``dst'' is not defined it will be set as os.path.basename(src).
    'antispamfeaturesremaptrigger': {
        'files': [
            {'src': ARC_WC_ROOT + 'yweb/robot/kiwi_queries/remap/triggers/antispamfeaturesremaptrigger/fnorm.dat', },
        ],
    },
    'catalogfeaturesremaptrigger': {
        'files': [
            {'src': YA_CATALOG_DATA + 'geoa.c2p', },
        ],
    },
    'clonattrsfiltertrigger': {
        'files': [
            {'src': YA_CATALOG_DATA + 'clatrbase_config', },
        ],
    },
    'contactpagefindertrigger': {
        'files': [
            {'src': ARC_WC_ROOT + 'yweb/clones/patterns/link_text.txt', },
            {'src': ARC_WC_ROOT + 'yweb/clones/patterns/url_text.txt', },
        ],
    },
    'convertertrigger': {
        'files': [
            {'src': ARC_TESTS_DATA_ROOT + 'recognize/dict.dict', },
        ],
    },
    'deducecalctrigger': antispam_tpl,
    'deducedumptrigger': antispam_tpl,
    'deduceruletrigger': antispam_tpl,
    'directtexttrigger': {
        'files': [
            {'src': PURE_TRIE, },
        ],
    },
    'erfpatchprinttrigger': {
        'files': [
            {'src': ARC_WC_ROOT + 'yweb/robot/kiwi_queries/remap/triggers/erfpatchprinttrigger/grouping.json', },
        ],
    },
    'exportranktrigger': {
        'files': [
            {'src': Scheme.RSYNC + '://realfeed01.search.yandex.net/realtime_export/current_export/exportrank.info'},
            {'src': Scheme.RSYNC + '://realfeed01.search.yandex.net/realtime_export/current_export/tr_exportrank.info'},
        ],
    },
    'fnormalizertrigger': {
        'files': [
            {'src': ARC_WC_ROOT + 'yweb/robot/kiwi_queries/antispam/triggers/fnormalizertrigger/fnorm.dat', },
        ],
    },
    'grammartrigger': {
        'files': [
            {'src': ARC_WC_ROOT + 'yweb/autoclassif/porno/pornoclass_lib/porno_weights', },
        ],
    },
    'groupattrstrigger': {
        'files': [
            {'src': YA_BERKANAVT + 'catalog/clatrbase_config', },
            {'src': YA_BERKANAVT + 'catalog/common.c2p', },
            {'src': YA_BERKANAVT + 'catalog/filter.obj', },
            {'src': YA_BERKANAVT + 'catalog/spl-grp.cfg', },
            {'src': ARC_WC_ROOT + 'yweb/urlrules/2ld.list', },
            {'src': ARC_WC_ROOT + 'yweb/urlrules/ungrouped.list', },
        ],
    },
    'groupingattrsfiltertrigger': {
        'files': [
            {'src': YA_CATALOG_DATA + 'spl-grp.cfg', },
            {'src': YA_CATALOG_DATA + 'clatrbase_config', },
            {'src': ARC_WC_ROOT + 'yweb/urlrules/ungrouped.list', },
            {'src': ARC_WC_ROOT + 'yweb/urlrules/2ld.list', },
        ],
    },
    'haslinkstohosttrigger': {
        'files': [
            {'src': ARC_TESTS_DATA_ROOT + 'catalogtriggers/hosts.txt', },
        ],
    },
    'hasspecifiedwordstrigger': {
        'files': [
            {'src': ARC_TESTS_DATA_ROOT + 'catalogtriggers/words.txt', },
        ],
    },
    'herfcreatetrigger': {
        'files': [
            {'src': YA_CATALOG_DATA + 'geoa.c2p', },
        ],
    },
    'herfprinttrigger': {
        'files': [
            {'src': ARC_WC_ROOT + 'yweb/robot/kiwi_queries/erf/triggers/herfprinttrigger/grouping.json', },
        ],
    },
    'htarcwalrusresolvertrigger': {
        'files': [
            {
                'src': ARC_WC_ROOT + 'yweb/common/roboconf/conf-production/host.cfg',
                'dst': 'production/config/host.cfg',
            },
        ],
    },
    'imagenumeratortrigger': {
        'files': [
            {'src': ARC_WC_ROOT + 'yweb/common/roboconf/htparser.ini', },
            {'src': ARC_WC_ROOT + 'extsearch/images/robot/parsers/html_parser/config/htparser.linktext.ini', },
            {'src': ARC_WC_ROOT + 'yweb/webscripts/video/zora/config.production/htparser.video.ini', },
        ],
    },
    'imageparsepagestrigger': {
        'files': [
            {'src': ARC_WC_ROOT + 'extsearch/images/robot/parsers/html_parser/config/htparser.linktext.ini', },
        ],
    },
    'imageparsertrigger': {
        'files': [
            {'src': ARC_TESTS_DATA_ROOT + 'images/ocr_runner/binarization_ranker_model', },
            {
                'src': ARC_TESTS_DATA_ROOT + 'images/ocr_runner/symbol_detector_models',
                'post_hook_name': 'gunzip_img_models',
            },

            {'src': ARC_TESTS_DATA_ROOT + 'images/ocr_runner/tessdata', },
            {'src': ARC_TESTS_DATA_ROOT + 'misspell', },
            {'src': ARC_TESTS_DATA_ROOT + 'images/ocr_runner/ocr.cfg', },

            {'src': ARC_TESTS_DATA_ROOT + 'images/multihead_wbp_net', },
            {'src': ARC_TESTS_DATA_ROOT + 'images/net.conf', },

            {'src': ARC_WC_ROOT + 'yweb/robot/kiwi_queries/images/triggers/imageparsertrigger/iparser.cfg', },
        ],
    },
    'thumbnail_parser_trigger': {
        'files': [
            {'src': ARC_TESTS_DATA_ROOT + 'images/ocr_runner/binarization_ranker_model', },
            {
                'src': ARC_TESTS_DATA_ROOT + 'images/ocr_runner/symbol_detector_models',
                'post_hook_name': 'gunzip_img_models',
            },

            {'src': ARC_TESTS_DATA_ROOT + 'images/ocr_runner/tessdata', },
            {'src': ARC_TESTS_DATA_ROOT + 'misspell', },
            {'src': ARC_TESTS_DATA_ROOT + 'images/ocr_runner/ocr.cfg', },

            {'src': ARC_WC_ROOT + 'yweb/robot/kiwi_queries/images/triggers/thumbnail_parser_trigger/iparser.cfg', },
        ],
    },
    'imagegenerictrigger': {
        'files': [
            {'src': ARC_WC_ROOT + 'yweb/robot/kiwi_queries/robot/triggers/imagegenerictrigger/iparser.cfg', },
        ],
    },
    'indexannportion': {
        'files': [
            {'src': ARC_TESTS_DATA_ROOT + 'recognize/queryrec/queryrec.dict', },
            {'src': ARC_TESTS_DATA_ROOT + 'recognize/queryrec/queryrec.weights', },
            {'src': ARC_TESTS_DATA_ROOT + 'recognize/queryrec/queryrec.filters', },
        ],
    },
    'linkextractortrigger': {
        'files': [
            {
                'src': ARC_WC_ROOT + 'yweb/urlrules/areas.lst',
                'dst': 'config/areas.lst',
            },
            {
                'src': BAD_WORDS_WEIGHTS,
                'dst': 'config/bad_words_weights.txt',
            },
            {
                'src': SEOLNK,
                'dst': 'config/seolnk',
            },
        ],
    },
    'links': {
        'files': [
            {
                'src': WORD_WHT_TRIE,
                'dst': 'links_data/wordwht.trie',
            },
            {
                'src': Scheme.RSYNC + '://lime.yandex.ru/place/berkanavt/links-data/1/config',
                'dst': 'links_data/config',
            },
            {
                'src': ARC_TESTS_DATA_ROOT + 'wizard/language',
                'dst': 'links_data/language',
            },
            {
                'src': YA_CATALOG_DATA + 'geoa.c2p',
                'dst': 'links_data/geoa.c2p',
            },
            {
                'src': YA_DATABASE_GOOGLE_DATA + 'link_adult.dict.bin',
                'dst': 'links_data/link_adult.dict.bin',
            },
            {
                'src': YA_DATABASE_GOOGLE_DATA + 'link_porno.dict.bin',
                'dst': 'links_data/link_porno.dict.bin',
            },
            {
                'src': YA_DATABASE_GOOGLE_DATA + 'new_direct.dict.bin',
                'dst': 'links_data/new_direct.dict.bin',
            },
            {
                'src': YA_DATABASE_GOOGLE_DATA + 'porno.txt',
                'dst': 'links_data/porno.txt',
            },
            {
                'src': PURE_TRIE,
                'dst': 'links_data/pure.trie',
            },
            {
                'src': ARC_WC_ROOT + 'yweb/urlrules/ungrouped.list',
                'dst': 'links_data/ungrouped.list',
            },
            {
                'src': ARC_WC_ROOT + 'yweb/urlrules/2ld.list',
                'dst': 'links_data/2ld.list',
            },
        ]
    },
    'mediacanonizertrigger': {
        'files': [
            {'src': ARC_WC_ROOT + 'yweb/webscripts/video/zora/config.production/url_generators.def', },
            {'src': ARC_WC_ROOT + 'yweb/webscripts/video/zora/config.production/url_generators.flashvars', },
            {'src': ARC_WC_ROOT + 'yweb/webscripts/video/waldata/config.production/simple_owners.lst', },
            {'src': ARC_WC_ROOT + 'yweb/webscripts/video/waldata/config.production/urlsconvert.thumbs.re', },
            {'src': ARC_WC_ROOT + 'yweb/webscripts/video/waldata/config.production/urlsconvert.urls.re', },
            {'src': ARC_WC_ROOT + 'yweb/webscripts/video/waldata/config.production/urlsconvert.original2thumb.re', },
            {'src': ARC_WC_ROOT + 'yweb/webscripts/video/waldata/config.production/urlsconvert.parsedurl.re', },
        ],
    },
    'mediatextrecognizertrigger': {
        'files': [
            {'src': ARC_TESTS_DATA_ROOT + 'recognize/dict.dict', },
        ],
    },
    'metadescrtrigger': {
        'files': [
            {'src': ARC_TESTS_DATA_ROOT + 'recognize/dict.dict', },
            {'src': ARC_TESTS_DATA_ROOT + 'wizard/language/stopword.lst', },
        ],
    },
    'mp3rangeparser': {
        'files': [
            {'src': ARC_TESTS_DATA_ROOT + 'recognize/dict.dict', },
        ],
    },
    'nameextractortrigger': {
        'files': [
            {
                'src': ARC_TESTS_DATA_ROOT + 'fact_extract/triggers_data/fio/name_extractor.cfg',
                'dst': 'name_extractor.cfg',
            },
            {
                'src': ARC_TESTS_DATA_ROOT + 'fact_extract/triggers_data/fio/rus_fio/fio.gzt.bin',
                'dst': 'rus_fio/fio.gzt.bin',
            },
            {
                'src': ARC_TESTS_DATA_ROOT + 'fact_extract/triggers_data/fio/rus_fio/fio.rules.bin',
                'dst': 'rus_fio/fio.rules.bin',
            },
            {
                'src': ARC_TESTS_DATA_ROOT + 'fact_extract/triggers_data/fio/rus_fio/main.proto',
                'dst': 'rus_fio/main.proto',
            },
            {
                'src': ARC_TESTS_DATA_ROOT + 'fact_extract/triggers_data/fio/rus_fio/name_filter.gzt.bin',
                'dst': 'rus_fio/name_filter.gzt.bin',
            },
            {
                'src': ARC_TESTS_DATA_ROOT + 'fact_extract/triggers_data/fio/ukr_fio/gzt.gzt.bin',
                'dst': 'ukr_fio/gzt.gzt.bin',
            },
            {
                'src': ARC_TESTS_DATA_ROOT + 'fact_extract/triggers_data/fio/ukr_fio/fio.rules.bin',
                'dst': 'ukr_fio/fio.rules.bin',
            },
            {
                'src': ARC_TESTS_DATA_ROOT + 'fact_extract/triggers_data/fio/ukr_fio/main.proto',
                'dst': 'ukr_fio/main.proto',
            },
            {
                'src': ARC_TESTS_DATA_ROOT + 'fact_extract/triggers_data/fio/ukr_fio/name_filter.gzt.bin',
                'dst': 'ukr_fio/name_filter.gzt.bin',
            },
            {
                'src': ARC_TESTS_DATA_ROOT + 'fact_extract/triggers_data/fio/tur_fio/fio.gzt.bin',
                'dst': 'tur_fio/fio.gzt.bin',
            },
            {
                'src': ARC_TESTS_DATA_ROOT + 'fact_extract/triggers_data/fio/tur_fio/fio.rules.bin',
                'dst': 'tur_fio/fio.rules.bin',
            },
            {
                'src': ARC_TESTS_DATA_ROOT + 'fact_extract/triggers_data/fio/tur_fio/main.proto',
                'dst': 'tur_fio/main.proto',
            },
            {
                'src': ARC_TESTS_DATA_ROOT + 'fact_extract/triggers_data/fio/tur_fio/name_filter.gzt.bin',
                'dst': 'tur_fio/name_filter.gzt.bin',
            },
        ],
    },
    'nevascalinkstrigger': {
        'files': [
            {'src': ARC_WC_ROOT + 'yweb/urlrules/areas.lst', },
            {'src': ARC_WC_ROOT + 'yweb/robot/aura/nevasca/ext_areas.re', },
            {'src': ARC_WC_ROOT + 'yweb/robot/aura/nevasca/translit.txt', },
        ],
    },
    'nevascaoldconvertertrigger': {
        'files': [
            {'src': ARC_WC_ROOT + 'yweb/urlrules/areas.lst', },
            {'src': ARC_WC_ROOT + 'yweb/robot/aura/nevasca/ext_areas.re', },
        ],
    },
    'nevascatrigger': {
        'files': [
            {'src': ARC_WC_ROOT + 'yweb/urlrules/areas.lst', },
            {'src': ARC_WC_ROOT + 'yweb/robot/aura/nevasca/ext_areas.re', },
        ],
    },
    'numbertrigger': {
        'files': [
            {'src': ARC_TESTS_DATA_ROOT + 'fact_extract/triggers_data/numbers/numbers.cfg', },
            {
                'src': ARC_TESTS_DATA_ROOT + 'fact_extract/triggers_data/numbers/rus/numbers.gzt.bin',
                'dst': 'rus/numbers.gzt.bin',
            },
            {
                'src': ARC_TESTS_DATA_ROOT + 'fact_extract/triggers_data/numbers/rus/numbers.remorph.bin',
                'dst': 'rus/numbers.remorph.bin',
            },
            {
                'src': ARC_TESTS_DATA_ROOT + 'fact_extract/triggers_data/numbers/rus/numbers.fact',
                'dst': 'rus/numbers.fact',
            },
            {
                'src': ARC_TESTS_DATA_ROOT + 'fact_extract/triggers_data/numbers/ukr/numbers.gzt.bin',
                'dst': 'ukr/numbers.gzt.bin',
            },
            {
                'src': ARC_TESTS_DATA_ROOT + 'fact_extract/triggers_data/numbers/ukr/numbers.remorph.bin',
                'dst': 'ukr/numbers.remorph.bin',
            },
            {
                'src': ARC_TESTS_DATA_ROOT + 'fact_extract/triggers_data/numbers/ukr/numbers.fact',
                'dst': 'ukr/numbers.fact',
            },
            {
                'src': ARC_TESTS_DATA_ROOT + 'fact_extract/triggers_data/numbers/tur/numbers.gzt.bin',
                'dst': 'tur/numbers.gzt.bin',
            },
            {
                'src': ARC_TESTS_DATA_ROOT + 'fact_extract/triggers_data/numbers/tur/numbers.remorph.bin',
                'dst': 'tur/numbers.remorph.bin',
            },
            {
                'src': ARC_TESTS_DATA_ROOT + 'fact_extract/triggers_data/numbers/tur/numbers.fact',
                'dst': 'tur/numbers.fact',
            },
        ],
    },
    'numeratortrigger': {
        'files': [
            {'src': ARC_WC_ROOT + 'yweb/common/roboconf/htparser.ini', },
            {'src': ARC_WC_ROOT + 'extsearch/images/robot/parsers/html_parser/config/htparser.linktext.ini', },
            {'src': ARC_WC_ROOT + 'yweb/webscripts/video/zora/config.production/htparser.video.ini', },
            {'src': ARC_WC_ROOT + 'yweb/blogs/htparser.config', },
        ],
    },
    'parsertrigger': {
        'files': [
            {'src': ARC_WC_ROOT + 'yweb/common/roboconf/htparser.ini', },
            {'src': ARC_WC_ROOT + 'extsearch/images/robot/parsers/html_parser/config/htparser.linktext.ini', },
        ],
    },
    'poetrytrigger': {
        'files': [
            {'src': FORCES_INFO, },
        ],
    },
    'queryfactortrigger': {
        'files': [
            {'src': ARC_WC_ROOT + 'yweb/pornofilter/comm.query', },
            {'src': ARC_WC_ROOT + 'yweb/pornofilter/payments.dict', },
            {'src': ARC_WC_ROOT + 'yweb/pornofilter/porno.query', },
            {'src': ARC_WC_ROOT + 'yweb/pornofilter/seo.query', },
        ],
    },
    'rcaparsedoctrigger': {
        'files': [
            {'src': ARC_WC_ROOT + 'yweb/urlrules/2ld.list', },
            {'src': ARC_TESTS_DATA_ROOT + 'wizard/language/stopword.lst', },
        ],
    },
    'recognizertrigger': {
        'files': [
            {'src': ARC_TESTS_DATA_ROOT + 'recognize/dict.dict', },
        ],
    },
    'regerfprinttrigger': {
        'files': [
            {'src': ARC_WC_ROOT + 'yweb/robot/kiwi_queries/remap/triggers/regerfprinttrigger/grouping.json', },
        ],
    },
    'reviewtrigger': {
        'files': [
        ],
    },
    'safebrowsingtrigger': {
        'files': [
            {'src': Scheme.RSYNC + '://vdb.yandex.ru/infection_info/google_hashes.bin', },
        ],
    },
    'searchattrsfiltertrigger': {
        'files': [
            {'src': YA_CATALOG_DATA + 'common.c2p', },
            {
                'src': YA_CATALOG_DATA + 'product.words',
                'dst': 'catalog/product.words'
            },
        ],
    },
    'seghostresolvertrigger': {
        'files': [
            {
                'src': ARC_WC_ROOT + 'yweb/common/roboconf/conf-production/host.cfg',
                'dst': 'production/config/host.cfg',
            },
            {
                'src': ARC_WC_ROOT + 'yweb/common/roboconf/conf-testing/host.cfg',
                'dst': 'testing/config/host.cfg',
            },
            {
                'src': ARC_WC_ROOT + 'yweb/common/roboconf/conf-staging/host.cfg',
                'dst': 'staging/config/host.cfg',
            },
            {
                'src': ARC_WC_ROOT + 'yweb/robot/kiwi_queries/robot/triggers/seghostresolvertrigger/empty_mirrors.trie',
                'dst': 'production/config/mirrors.trie',
            },
            {
                'src': ARC_WC_ROOT + 'yweb/robot/kiwi_queries/robot/triggers/seghostresolvertrigger/empty_mirrors.trie',
                'dst': 'testing/config/mirrors.trie',
            },
            {
                'src': ARC_WC_ROOT + 'yweb/robot/kiwi_queries/robot/triggers/seghostresolvertrigger/empty_mirrors.trie',
                'dst': 'staging/config/mirrors.trie',
            },
        ],
    },
    'segmentatortrigger': {
        'files': [
            {'src': ARC_WC_ROOT + 'yweb/urlrules/2ld.list', },
        ],
    },
    'serpapiresizeimagestrigger': {
        'files': [
            {'src': ARC_WC_ROOT + 'yweb/robot/kiwi_queries/serp_api/triggers/serpapiresizeimagestrigger/iparser.cfg', },
        ],
    },
    'shoptrigger': {
        'files': [
            {'src': SHOP + 'review.model', },
            {'src': SHOP + 'shop.dat', },
            {'src': SHOP + 'shop.model', },
        ],
    },
    'sitesearchmicrodataextractortrigger': {
        'files': [
            {'src': ARC_WC_ROOT + 'yweb/robot/kiwi_queries/wmconsole/triggers/sitesearchmicrodataextractortrigger/extractor.xml', },
        ],
    },
    'sophosavtrigger': {
        'files': [
            {'src': ARC_WC_ROOT + 'yweb/robot/kiwi_queries/antivirus/triggers/sophosavtrigger/sav_conf.ini', },
            {'src': Scheme.RSYNC + '://vdb.yandex.ru/sophos_kiwi/', 'dst': '.', },
        ],
    },
    'socialdatatrigger': {
        'files': [
            {'src': ARC_TESTS_DATA_ROOT + 'quality/social_networks/geodata.gzt.bin', },
            {'src': ARC_TESTS_DATA_ROOT + 'quality/social_networks/geoinfo.tsv', },
        ],
    },
    'synonymtrigger': {
        'files': [
            {'src': ANTISYN + 'counters.bin', },
            {'src': ANTISYN + 'dict_coords.bin', },
            {'src': ANTISYN + 'paradigms.bin', },
            {'src': ANTISYN + 'result.bin', },
            {'src': ARC_WC_ROOT + 'yweb/antispam/antisyn/generate_data/paradigms2bin/paradigms.txt', },
        ],
    },
    'titlefeaturetrigger': {
        'files': [
            {'src': ARC_TESTS_DATA_ROOT + 'wizard/commercial/commercial.dict.bin', },
            {'src': PURE_TRIE, },
        ],
    },
    'tmucalctrigger': antispam_tpl,
    'tmudumptrigger': antispam_tpl,
    'tmuexporttrigger': antispam_tpl,
    'ukropresolvertrigger': {
        'files': [
            {
                'src': ARC_WC_ROOT + 'yweb/robot/ukrop/conf/ukroppoints.txt',
                'dst': 'data/ukroppoints.txt'
            },
        ],
    },
    'uploadranktrigger': {
        'files': [
            {'src': ARC_WC_ROOT + 'yweb/urlrules/f2ld.list', },
            {'src': YA_CATALOG_DATA + 'geoa.c2p', },
            {'src': YA_BERKANAVT + 'dbspider/globalconfig/towns', },
        ],
    },
    'url2group': {
        'files': [
            {'src': ARC_WC_ROOT + 'robot/library/oxygen/config/files/hostcfg.txt', },
        ],
    },
    'urlattrsfiltertrigger': {
        'files': [
            {'src': YA_CATALOG_DATA + 'filter.trie', },
        ],
    },
    'urltoownertrigger': {
        'files': [
            {
                'src': ARC_WC_ROOT + 'yweb/urlrules/areas.lst',
                'dst': 'data/areas.lst',
            },
        ],
    },
    'urltrigger': {
        'files': [
            {'src': ARC_DATA_ROOT + 'robot/geocityurl/geocityurl.bin', },
            {'src': ARC_DATA_ROOT + 'robot/geocountryurl/geocountryurl.bin', },
            {'src': YA_BERKANAVT + 'erfdata/gskUrlModel.batch', },
            {'src': YA_BERKANAVT + 'erfdata/ngrams_clusters.txt', },
            {'src': YA_BERKANAVT + 'erfdata/ngrams_model.info', },
            {'src': YA_BERKANAVT + 'erfdata/url_trigrams_model.bin', },
            {'src': YA_BERKANAVT + 'urlrules/subhost-owners.re', },
        ],
    },
    'videohostparsertrigger': {
        'files': [
            {'src': ARC_WC_ROOT + 'yweb/webscripts/video/zora/config.production/htparser.linktext.ini', },
            {'src': ARC_WC_ROOT + 'yweb/webscripts/video/zora/config.production/url_generators.def', },
            {'src': ARC_WC_ROOT + 'yweb/webscripts/video/zora/config.production/url_generators.flashvars', },
            {'src': ARC_WC_ROOT + 'extsearch/images/robot/parsers/html_parser/fast/indexarch/uselessflash.lst', },
        ],
    },
    'videolinksextractortrigger': {
        'files': [
            {'src': ARC_WC_ROOT + 'yweb/webscripts/video/canonize/config/simple_owners.lst', },
            {'src': ARC_WC_ROOT + 'yweb/webscripts/video/canonize/config/apigenerator.re', },
            {'src': ARC_WC_ROOT + 'yweb/webscripts/video/canonize/config/forcedapigenerator.re', },
            {'src': ARC_WC_ROOT + 'yweb/webscripts/video/canonize/config/playlist.re', },
            {'src': ARC_WC_ROOT + 'yweb/webscripts/video/canonize/config/forcedplaylist.re', },
        ],
    },
    'videopageparsertrigger': {
        'files': [
            {'src': ARC_WC_ROOT + 'yweb/webscripts/video/zora/config.production/htparser.linktext.ini', },
            {'src': ARC_WC_ROOT + 'yweb/webscripts/video/zora/config.production/url_generators.def', },
            {'src': ARC_WC_ROOT + 'yweb/webscripts/video/zora/config.production/url_generators.flashvars', },
            {'src': ARC_WC_ROOT + 'extsearch/images/robot/parsers/html_parser/fast/indexarch/uselessflash.lst', },
        ],
    },
    'videoplayertrigger': {
        'files': [
            {'src': ARC_WC_ROOT + 'yweb/webscripts/video/kiwi/videoplayertrigger/mediaplayers.cfg', },
            {'src': ARC_WC_ROOT + 'yweb/webscripts/video/kiwi/videoplayertrigger/iframeplayers.re', },
        ],
    },
    'videosoft404trigger': {
        'files': [
            {'src': ARC_WC_ROOT + 'yweb/webscripts/video/kiwi/videosoft404trigger/soft404.conf', },
            {'src': ARC_WC_ROOT + 'yweb/video/soft404/features', },
            {'src': ARC_WC_ROOT + 'yweb/video/soft404/models', },
        ],
    },
    'xpathmarkertrigger': {
        'files': [
            {'src': ARC_WC_ROOT + 'yweb/robot/kiwi_queries/robot/triggers/xpathmarkertrigger/xpaths.json', },
        ],
    },
    'socnetauthorbuildertrigger': {
        'files': [
            {'src': ARC_WC_ROOT + 'yweb/robot/kiwi_queries/socnet_entity/triggers/socnetauthorbuildertrigger/builder.cfg', },
        ],
    },
    'socnetauthortosnippettrigger': {
        'files': [
            {'src': ARC_WC_ROOT + 'yweb/robot/kiwi_queries/socnet_entity/triggers/socnetauthortosnippettrigger/tosnippet_realtime.cfg', },
            {'src': ARC_WC_ROOT + 'yweb/robot/kiwi_queries/socnet_entity/triggers/socnetauthortosnippettrigger/tosnippet_merge.cfg', },
        ],
    },
}

# vim:set ts=4 sw=4 et:
