"""Function for making form fields for the task.
"""

from sandbox.sandboxsdk import parameters

from sandbox.projects.common.build import parameters as build_parameters
from sandbox.projects.BuildKiwiTriggers import cfg

input_parameters = []


def input_parameter(param):
    input_parameters.append(param)


@input_parameter
class TaskMode(parameters.SandboxRadioParameter):
    name = 'task_mode'
    description = 'Task mode'
    choices = [
        ('ya kiwi build (for trunk and new branches now)', 'use_ya_impl'),
        ('internal implementation (deprecated, use it for old branches)', 'use_sandbox_impl')
    ]
    sub_fields = {
        'use_sandbox_impl': [
            'triggers_svn_path',
            'multi_arch',
            'gcc_version',
            'use_pregenerated_mq',
            'triggers_specific_str',
            'build_set',
            'triggers_svn_meta_path'
        ],
        'use_ya_impl': [
            'targets_str'
        ]
    }
    per_line = 2
    default_value = 'use_ya_impl'


@input_parameter
class BuildTriggersArcadiaUrl(build_parameters.BuildArcadiaUrl):
    name = 'build_triggers_arcadia_url'
    description = 'Arcadia svn url'
    default_value = cfg.TRUNK_SVN_ROOT
    required = True


@input_parameter
class TriggersSvnPath(parameters.SandboxStringParameter):
    name = 'triggers_svn_path'
    description = 'Triggers svn path'
    default_value = cfg.DEFAULT_TRIGGERS_SVN_PATH


@input_parameter
class MultiArch(parameters.SandboxBoolParameter):
    name = 'multi_arch'
    description = 'Multi-arch build'
    hidden = True


@input_parameter
class BuildType(parameters.SandboxRadioParameter):
    name = 'build_type'
    description = 'Build type'
    choices = [
        ('release', 'release'),
        ('debug', 'debug'),
        ('valgrind', 'valgrind'),
        ('coverage', 'coverage'),
        ('release with debug info', 'RelWithDebInfo')
    ]
    per_line = 3
    default_value = 'release'


@input_parameter
class UseCcache(parameters.SandboxBoolParameter):
    name = 'use_ccache'
    description = 'Use ccache (works only with ya impl)'


@input_parameter
class GccVersion(parameters.SandboxRadioParameter):
    name = 'gcc_version'
    description = 'Use gcc version'
    choices = [
        ('4.4', '4.4'),
        ('4.7', '4.7')
    ]
    per_line = 2
    default_value = '4.7'


@input_parameter
class UsePregeneratedMq(parameters.SandboxBoolParameter):
    name = 'use_pregenerated_mq'
    description = 'Use MetaQuery instead of MetaData (experimental)'


# Set of triggers


@input_parameter
class InfoTriggersSet(parameters.SandboxInfoParameter):
    name = 'info_triggers_set'
    description = 'Set of triggers'


# ya kiwi build fields.


@input_parameter
class TargetsStr(parameters.SandboxStringParameter):
    name = 'targets_str'
    description = 'Targets to build, one per line (yweb/robot/..)'
    multiline = True
    required = True


@input_parameter
class UseDevVersion(parameters.SandboxBoolParameter):
    name = 'use_dev_version'
    description = 'Use developer version of ya (from devtools/ya-dev/ya)'


# Internal implementation fields.


@input_parameter
class BuildSet(parameters.SandboxRadioParameter):
    name = 'build_set'
    description = 'Set of triggers to build'
    choices = [
        ('get from meta directory', 'meta'),
        ('specify manually', 'specific')
    ]
    sub_fields = {
        'meta': [
            'triggers_svn_meta_path',
        ],
        'specific': ['triggers_specific_str']
    }
    per_line = 3
    default_value = 'specific'


@input_parameter
class TriggersSvnMetaPath(parameters.SandboxStringParameter):
    name = 'triggers_svn_meta_path'
    description = 'Triggers svn meta path'
    default_value = cfg.DEFAULT_TRIGGERS_SVN_META_PATH


@input_parameter
class TriggersApecificStr(parameters.SandboxStringParameter):
    name = 'triggers_specific_str'
    description = 'Triggers basenames, one per line, empty == all'
    multiline = True
