# -*- coding: utf-8 -*-

import sandbox.common.types.client as ctc

from sandbox.projects import resource_types
from sandbox.projects.common.build.YaMake import YaMakeTask
from sandbox.projects.common.nanny import nanny

import sandbox.projects.common.build.parameters as build_params


class BuildKomutator(YaMakeTask, nanny.ReleaseToNannyTask):
    """
        Build Komutator
    """

    type = 'BUILD_KOMUTATOR'

    client_tags = YaMakeTask.client_tags & ctc.Tag.Group.LINUX

    input_parameters = [
        build_params.ArcadiaUrl,
        build_params.ArcadiaPatch,
        build_params.DefinitionFlags,
        build_params.TestParameter,
    ]

    def get_targets(self):
        return [
            'yweb/incproc/komutator',
        ]

    def get_arts(self):
        return [
            {'path': 'yweb/incproc/komutator/driver/komutator'},
        ]

    def get_resources(self):
        project = {}
        project['resource_type'] = resource_types.KOMUTATOR_EXECUTABLE
        project['description'] = 'Komutator executable'
        project['resource_path'] = 'komutator'
        return {'project': project}

    def on_release(self, additional_parameters):
        nanny.ReleaseToNannyTask.on_release(self, additional_parameters)
        YaMakeTask.on_release(self, additional_parameters)


__Task__ = BuildKomutator
