# -*- coding: utf-8 -*-
import os
import re

import sandbox.common.types.client as ctc

from sandbox.sandboxsdk import parameters
from sandbox.sandboxsdk.svn import Arcadia

from sandbox.projects.common.build.BaseSimpleBuildTaskWithPkg import BaseSimpleBuildTaskWithPkg
import sandbox.projects.common.constants as consts

from sandbox.projects import resource_types


class BuildKwrich(BaseSimpleBuildTaskWithPkg):
    type = 'BUILD_KWRICH'
    client_tags = ctc.Tag.LINUX_PRECISE

    class InfoFieldBin(parameters.SandboxInfoParameter):
        name = 'info_field_bin'
        description = 'Kwrich Binary'

    class BuildKwrich(parameters.SandboxBoolParameter):
        name = 'build_kwrich'
        description = 'kwrich'

    input_parameters = BaseSimpleBuildTaskWithPkg.input_parameters + [
        InfoFieldBin,
        BuildKwrich,
    ]

    TARGET_RESOURCES = (
       (resource_types.KWRICH, 'zora/xcalc/kwrich/kwrich'),
    )

    RESOURCE_TO_PKG_MAP = {
        'freebsd': {
        },
        'linux': {
            'KWRICH': 'packages/debian/kwrich/yandex-search-kwrich-bin',
        },
    }

    PKG_CTX = {
        'repo_key_id': 'Robot-Admins (https://staff.yandex-team.ru/robot-admins/) <robot-admins@yandex-team.ru>',
        'gpg_private_key': 'robot-admins-gpg-private',
        'gpg_public_key': 'robot-admins-gpg-public',
        'ssh_private_key': 'robot-admins-ssh',
    }

    def do_execute(self):

        if self.do_pkg_tasks_exist():
            self.check_pkg_tasks()
            return

        self.ctx[consts.ARCADIA_URL_KEY] = self.normalize_svn_url(self.ctx[consts.ARCADIA_URL_KEY])

        os.putenv('LD_LIBRARY_PATH', '')
        BaseSimpleBuildTaskWithPkg.do_execute(self)

        if self.are_pkgs_enabled():
            self.mark_resources_ready()
            self.create_pkg_tasks(self.PKG_CTX)

    @staticmethod
    def normalize_svn_url(svn_url):
        path = Arcadia.parse_url(svn_url).path
        svn_path = re.sub(r'/arcadia.*', '/arcadia', path, count=1)
        return Arcadia.replace(svn_url, path=svn_path)


__Task__ = BuildKwrich
