from sandbox.projects import resource_types
# noinspection PyProtectedMember
from sandbox.projects.common.build.BuildForAllTask import VersionParameter
import sandbox.projects.common.build.ScriptBuildTask as sbt


class LibFFIVersion(VersionParameter):
    description = 'libffi version'
    default_value = '3.99999'


class BuildLibFFI(sbt.ScriptBuildTask):
    type = 'BUILD_LIBFFI'
    input_parameters = [LibFFIVersion] + sbt.get_script_build_params()
    execution_space = 1000

    # ScriptBuildTask fields
    tool_name = 'libffi'
    resource_type = resource_types.FFI_LIBRARY


__Task__ = BuildLibFFI
