from sandbox.projects import resource_types
# noinspection PyProtectedMember
from sandbox.projects.common.build.BuildForAllTask import VersionParameter
import sandbox.projects.common.build.ScriptBuildTask as sbt


class LibMysqlClientVersion(VersionParameter):
    description = 'libmysqlclient version'
    default_value = '6.1.6'


class BuildLibMysqlClient(sbt.ScriptBuildTask):
    type = 'BUILD_LIBMYSQLCLIENT'
    input_parameters = [LibMysqlClientVersion] + sbt.get_script_build_params()
    execution_space = 2000

    # ScriptBuildTask fields
    tool_name = 'libmysqlclient'
    resource_type = resource_types.MYSQLCLIENT_LIBRARY


__Task__ = BuildLibMysqlClient
