from sandbox.projects import resource_types
# noinspection PyProtectedMember
from sandbox.projects.common.build.BuildForAllTask import VersionParameter
import sandbox.projects.common.build.ScriptBuildTask as sbt


class LibSnappyVersion(VersionParameter):
    description = 'Libsnappy version'
    default_value = '1.0.4'


class BuildLibSnappy(sbt.ScriptBuildTask):
    type = 'BUILD_LIBSNAPPY'
    input_parameters = [LibSnappyVersion] + sbt.get_script_build_params()
    execution_space = 1000

    # ScriptBuildTask fields
    tool_name = 'libsnappy'
    resource_type = resource_types.SNAPPY_LIBRARY


__Task__ = BuildLibSnappy
