# -*- coding: utf-8 -*-

import os
import shutil

from sandbox.projects import resource_types
from sandbox.projects.common.build.YaMake import YaMakeTask, BUILD_DIR


class BuildLibSuperResolutionRaw(YaMakeTask):
    """
        build superres lib - library for image upscaling by neural net
    """

    type = 'BUILD_LIBSUPERRES'

    @property
    def targets_description(self):
        return [
            ('cv/imageproc/superres/dynamic/libsuperres.so', 'libsuperres.so', resource_types.CV_RAW_COCAINE_LIBRARY, 'cv/imageproc/superres/dynamic'),
        ]

    execution_space = 20 * 1024  # 20 GB
    input_parameters = [p for p in YaMakeTask.input_parameters if p.name not in ['targets']]

    HEADERS_DIR = 'inc/'

    def export_build_resources(self):
        src_path = BUILD_DIR

        for res in self.targets_description:
            res_path, filename, res_type, _ = res
            to_path = self.abs_path(filename)
            from_path = os.path.join(src_path, res_path)
            if os.path.isdir(from_path):
                shutil.copytree(from_path, to_path)
            else:
                shutil.copy(from_path, to_path)
            self.create_resource(filename, to_path, res_type)

        header_path = os.path.join(self.get_arcadia_src_dir(), 'cv', 'imageproc', 'superres', 'transform.h')
        os.mkdir(self.HEADERS_DIR)
        shutil.copy(header_path, self.HEADERS_DIR)
        self.create_resource('inc', self.HEADERS_DIR, resource_types.CV_RAW_COCAINE_HEADERS)

    def do_execute(self):
        YaMakeTask.do_execute(self)
        self.export_build_resources()

    def get_targets(self):
        return [res[3] for res in self.targets_description]


__Task__ = BuildLibSuperResolutionRaw
