# -*- coding: utf-8 -*-

import os
import shutil

from sandbox.projects import resource_types
from sandbox.projects.common.build.CommonBuildTask import CommonBuildTask


class BuildImageParserRaw(CommonBuildTask):
    """
        build licenseplate lib - library for licenseplate bluring
    """

    type = 'BUILD_LICENSEPLATE'

    TARGET_RESOURCES = (
        (resource_types.CV_RAW_COCAINE_LIBRARY, 'cv/imageproc/licenseplate/dynamic/liblicenseplate.so'),
    )

    execution_space = 20000

    HEADERS_DIR = 'inc/'

    def do_execute(self):
        arcadia_src_dir = self.get_arcadia_src_dir()

        header_path = os.path.join(arcadia_src_dir, 'cv', 'imageproc', 'licenseplate', 'idetector.h')
        os.mkdir(self.HEADERS_DIR)
        shutil.copy(header_path, self.HEADERS_DIR)
        self.create_resource('inc', self.HEADERS_DIR, resource_types.CV_RAW_COCAINE_HEADERS)

        CommonBuildTask.do_execute(self)


__Task__ = BuildImageParserRaw
