# -*- coding: utf-8 -*-

import os
import logging

from sandbox.projects import resource_types
from sandbox.projects.common import error_handlers as eh
from sandbox.sandboxsdk.process import run_process
from sandbox.sandboxsdk.task import SandboxTask
from sandbox.sandboxsdk.svn import Arcadia


class BuildLoadLogDump(SandboxTask):
    type = 'BUILD_LOADLOGDUMP'

    def on_execute(self):
        logging.info('on_execute started...')

        os.chdir(self.abs_path())

        Arcadia.export(Arcadia.trunk_url('search/config/virthost.h'), self.abs_path('virthost.h'))
        Arcadia.export(Arcadia.trunk_url('kernel/search_daemon_iface/reqtypes.h'), self.abs_path('reqtypes.h'))
        Arcadia.export(
            Arcadia.trunk_url('search/tools/loadlogdump/gen_structs_for_loadlogdump.py'),
            self.abs_path('gen_structs_for_loadlogdump.py')
        )
        Arcadia.export(
            Arcadia.trunk_url('search/tools/loadlogdump/loadlogdump_src.py'),
            self.abs_path('loadlogdump_src.py')
        )

        eh.ensure(
            run_process('python gen_structs_for_loadlogdump.py', log_prefix='run-test', check=False).returncode == 0,
            'Build LoadLogDump failed'
        )
        self.create_resource('LoadLogDump executable', 'loadlogdump.py', resource_types.LOADLOGDUMP_EXECUTABLE, arch='any')


__Task__ = BuildLoadLogDump
