# -*- coding: utf-8 -*-

import copy

from sandbox.projects import resource_types
from sandbox.projects.common.geosearch.factors_filter import (
    BuildMapsFilteredFactors, HostFactorsParameter
)


class BuildMapsFilteredHostFactors(BuildMapsFilteredFactors):
    factors_type = 'hostfactors'
    factors_parameter = HostFactorsParameter
    factors_resource_type = resource_types.MAPS_GEO_HOST_FACTORS_FILTERED

    type = 'BUILD_MAPS_FILTERED_HOST_FACTORS'
    input_parameters = copy.copy(BuildMapsFilteredFactors.input_parameters) + [factors_parameter]
    execution_space = 100 * 1024  # 100 Gb


__Task__ = BuildMapsFilteredHostFactors
