# -*- coding: utf-8 -*-

import copy

from sandbox.projects import resource_types
from sandbox.projects.common.geosearch.factors_filter import (
    BuildMapsFilteredFactors, WebUserFactorsParameter
)


class BuildMapsFilteredWebUserFactors(BuildMapsFilteredFactors):
    factors_type = 'userfactors'
    factors_parameter = WebUserFactorsParameter
    factors_resource_type = resource_types.MAPS_WEB_USER_FACTORS_FILTERED

    type = 'BUILD_MAPS_FILTERED_WEB_USER_FACTORS'
    input_parameters = copy.copy(BuildMapsFilteredFactors.input_parameters) + [factors_parameter]


__Task__ = BuildMapsFilteredWebUserFactors
