# -*- coding: utf-8 -*-
import os

from sandbox import sdk2

import sandbox.projects.resource_types.releasers as rr
import sandbox.projects.resource_types as rt
import sandbox.common.types.resource as ctr
from sandbox.sdk2.helpers import subprocess as sp


class MapsStaticFactors(sdk2.Resource):
    """
        static factors file
    """
    releasable = True
    releasers = rr.geosearch_releasers
    auto_backup = True
    pass


class MapsRubricStaticFactors(sdk2.Resource):
    """
        static factors file
    """
    releasable = True
    releasers = rr.geosearch_releasers
    auto_backup = True
    pass


class MapsChainStaticFactors(sdk2.Resource):
    """
        static factors file
    """
    releasable = True
    releasers = rr.geosearch_releasers
    auto_backup = True
    pass


KEY_TO_RESOURCE = {
    'Oid': MapsStaticFactors,
    'Rubric': MapsRubricStaticFactors,
    'Chain': MapsChainStaticFactors,
}


class BuildMapsStaticFactorsDownloader(sdk2.Task):
    """
        From anything yt tables -> file
    """
    class Parameters(sdk2.Parameters):
        with sdk2.parameters.Group('Stable resources') as r:
            binary_downloader = sdk2.parameters.Resource(
                'Ready resource to download static factors',
                resource_type=rt.GEOSEARCH_STATIC_DOWNLOADER_EXECUTABLE,
                state=(ctr.State.READY, ),
                required=True,
            )
            yt_server = sdk2.parameters.String('Yt server', default='hahn')
            list_inputs = sdk2.parameters.List('List of input yt tables')
            key_column_name = sdk2.parameters.String("Key column name", choices=[(key, key) for key in KEY_TO_RESOURCE], default='Oid')
            output_file = sdk2.parameters.String('Output file', default='static_factors.mms')

    def on_execute(self):
        output_file = os.path.abspath(self.Parameters.output_file)
        bin_res = sdk2.ResourceData(self.Parameters.binary_downloader)
        key_column_name = self.Parameters.key_column_name

        yt_token = sdk2.Vault.data('GEOMETA-SEARCH', 'yt-token')
        yt_tokenfile = 'yt_token.txt'
        with open(yt_tokenfile, 'w') as output:
            output.write(yt_token)

        cmd = [
            str(bin_res.path),
            '-o', output_file,
            '-s', self.Parameters.yt_server,
            '-t', yt_tokenfile,
            '-k', key_column_name
        ]
        for inp in self.Parameters.list_inputs:
            if inp:
                cmd += ['-i', inp]

        with sdk2.helpers.ProcessLog(self, logger='downloader') as l:
            sp.check_call(cmd, stdout=l.stdout, stderr=l.stderr)

        resource_cls = KEY_TO_RESOURCE[key_column_name]
        resource = resource_cls(self, key_column_name + " static factors file", output_file)
        sdk2.ResourceData(resource).ready()
