# -*- coding: utf-8 -*-

import os
import time

from sandbox.projects import resource_types
from sandbox.projects.common.build.YaMake import YaMakeTask
import sandbox.projects.common.build.parameters as build_params


class BuildMarketReport(YaMakeTask):

    type = 'BUILD_MARKET_REPORT'

    TARGET_BINARY_TYPES = [
        resource_types.MARKET_REPORT_BINARY,
    ]
    TARGET_SOURCE_TYPES = [
        resource_types.MARKET_REPORT_CONFIG_GENERATOR,
    ]
    TARGET_RESOURCE_TYPES = TARGET_BINARY_TYPES + TARGET_SOURCE_TYPES

    input_parameters = [
        build_params.ArcadiaUrl,
        build_params.ArcadiaPatch,
        build_params.BuildSystem,
        build_params.BuildType,
    ]

    def get_targets(self):
        return [resource_type.arcadia_build_path
                for resource_type in self.TARGET_BINARY_TYPES]

    def get_arts(self):
        return [{'path': resource_type.arcadia_build_path}
                for resource_type in self.TARGET_BINARY_TYPES]

    def get_arts_source(self):
        return [{'path': resource_type.arcadia_build_path}
                for resource_type in self.TARGET_SOURCE_TYPES]

    def get_resources(self):
        resources = {}
        for resource_type in self.TARGET_RESOURCE_TYPES:
            resource = {
                'description': resource_type.name,
                'resource_type': resource_type,
                'resource_path': os.path.basename(resource_type.arcadia_build_path),
            }
            resources[resource_type.name] = resource
        return resources

    def pre_build(self, *args):
        # old-style class => call directly
        YaMakeTask.pre_build(self, *args)
        self.ctx['start_build_time'] = time.time()

    def post_build(self, *args):
        self.ctx['finish_build_time'] = time.time()
        # old-style class => call directly
        YaMakeTask.post_build(self, *args)


__Task__ = BuildMarketReport
