# -*- coding: utf-8 -*-

import os

from sandbox.projects import resource_types
from sandbox.projects.common.build.YaMake import YaMakeTask
import sandbox.projects.common.build.parameters as build_params


class BuildMatrixnet(YaMakeTask):

    type = 'BUILD_MATRIXNET'

    TARGET_RESOURCE_TYPES = [
        resource_types.MATRIXNET_EXECUTABLE,
    ]

    input_parameters = [
        build_params.ArcadiaUrl,
        build_params.ArcadiaPatch,
        build_params.BuildSystem,
        build_params.BuildType,
    ]

    def get_targets(self):
        return [resource_type.arcadia_build_path
                for resource_type in self.TARGET_RESOURCE_TYPES]

    def get_resources(self):
        resources = {}
        for resource_type in self.TARGET_RESOURCE_TYPES:
            resource = {
                'description': resource_type.name,
                'resource_type': resource_type,
                'resource_path': os.path.basename(resource_type.arcadia_build_path),
            }
            resources[resource_type.name] = resource

        return resources

    def get_arts(self):
        return [
                    {'path': resource_type.arcadia_build_path} for resource_type in self.TARGET_RESOURCE_TYPES
                ]


__Task__ = BuildMatrixnet
