# -*- coding: utf-8 -*-

import os
import __builtin__

from sandbox.sandboxsdk import parameters

from sandbox.projects.common.build.CommonBuildTask import CommonBuildTask

from sandbox.projects import resource_types
from sandbox.sandboxsdk.paths import get_logs_folder


class BuildMirrorScheduler(CommonBuildTask):
    type = 'BUILD_MIRROR_SCHEDULER'

    class Release(parameters.SandboxBoolParameter):
        name = 'release'
        description = 'Release'
        default_value = True

    class SchedulerBinariesBlock(parameters.SandboxInfoParameter):
        name = 'info_field'
        description = 'Scheduler binaries'

    input_parameters = CommonBuildTask.input_parameters + [Release, SchedulerBinariesBlock] + [
        __builtin__.type(
            'build_' + descr,
            (parameters.SandboxBoolParameter,),
            dict(name='build_' + descr, description=descr)
        )
        for descr in (
            'pagecmp', 'scheduler', 'scheduler2', 'fetcher', 'fetcher_online', 'batchresolver', 'mdbutil',
            'zsproxy', 'datawork', 'filter_build', 'make_filter', 'mirrmanip', 'mkcyhash'
        )
    ]

    TARGET_RESOURCES = (
        (resource_types.MIRROR_SCHEDULER, 'robot/mirror/scheduler/mirror-scheduler'),
        (resource_types.SCHEDULER2, 'robot/mirror/scheduler2/scheduler2'),
        (resource_types.FETCHER, 'robot/mirror/fetcher/main/fetcher'),
        (resource_types.ONLINE_CHECKER, 'robot/mirror/online_checker/online_checker'),
        (resource_types.BATCHRESOLVER, 'robot/mirror/batchresolver/batchresolver'),
        (resource_types.PAGECMP, 'robot/mirror/pagecmp/pagecmp'),
        (resource_types.MDBUTIL, 'robot/mirror/mdbutil/mdbutil'),
        (resource_types.ZSPROXY, 'robot/mirror/proxy/zsproxy'),
        (resource_types.DATAWORK, 'yweb/robot/datawork/datawork'),
        (resource_types.FILTER_BUILD, 'yweb/robot/tools/filter_build/filter_build'),
        (resource_types.MAKE_FILTER, 'yweb/webutil/make_filter/make_filter'),
        (resource_types.MIRRMANIP, 'robot/mirror/listmanip/mirrmanip'),
        (resource_types.MKCYHASH, 'robot/mirror/tools/mkcyhash/mkcyhash'),
    )

    def initCtx(self):
        self.ctx['build_bundle'] = True
        CommonBuildTask.initCtx(self)

    def on_execute(self):

        CommonBuildTask.on_execute(self)
        log_path = get_logs_folder()
        out_str = ''
        if(self.ctx['build_pagecmp']): out_str += ',"pagecmp_resource_id":"%s"' % list(self.list_resources(resource_types.PAGECMP))[0].id
        if(self.ctx['build_scheduler']): out_str += ',"mirror_scheduler_resource_id":"%s"' % list(self.list_resources(resource_types.MIRROR_SCHEDULER))[0].id
        if(self.ctx['build_scheduler2']): out_str += ',"scheduler2_resource_id":"%s"' % list(self.list_resources(resource_types.SCHEDULER2))[0].id
        if(self.ctx['build_fetcher']): out_str += ',"fetcher_resource_id":"%s"' % list(self.list_resources(resource_types.FETCHER))[0].id
        if(self.ctx['build_online_checker']): out_str += ',"online_checker_resource_id":"%s"' % list(self.list_resources(resource_types.ONLINE_CHECKER))[0].id
        if(self.ctx['build_mdbutil']): out_str += ',"mdbutil_resource_id":"%s"' % list(self.list_resources(resource_types.MDBUTIL))[0].id
        if(self.ctx['build_zsproxy']): out_str += ',"zsproxy_resource_id":"%s"' % list(self.list_resources(resource_types.ZSPROXY))[0].id
        if(self.ctx['build_batchresolver']): out_str += ',"batchresolver_resource_id":"%s"' % list(self.list_resources(resource_types.BATCHRESOLVER))[0].id
        if(self.ctx['build_datawork']): out_str += ',"datawork_resource_id":"%s"' % list(self.list_resources(resource_types.DATAWORK))[0].id
        if(self.ctx['build_filter_build']): out_str += ',"filter_build_resource_id":"%s"' % list(self.list_resources(resource_types.FILTER_BUILD))[0].id
        if(self.ctx['build_make_filter']): out_str += ',"make_filter_resource_id":"%s"' % list(self.list_resources(resource_types.MAKE_FILTER))[0].id
        if(self.ctx['build_mirrmanip']): out_str += ',"mirrmanip_resource_id":"%s"' % list(self.list_resources(resource_types.MIRRMANIP))[0].id
        if(self.ctx['build_mkcyhash']): out_str += ',"mkcyhash_resource_id":"%s"' % list(self.list_resources(resource_types.MKCYHASH))[0].id

        open(os.path.join(log_path, 'mirror.id.out.txt'), "w").write(out_str)


__Task__ = BuildMirrorScheduler
