import os

import sandbox.common.types.client as ctc

from sandbox.projects import resource_types
# noinspection PyProtectedMember
from sandbox.projects.common.build.BuildForAllTask import VersionParameter
import sandbox.projects.common.build.ScriptBuildTask as sbt


class MongoVersion(VersionParameter):
    description = 'mongo version'
    default_value = '3.2.7'


class BuildMongo(sbt.ScriptBuildTask):
    type = 'BUILD_MONGO'
    client_tags = ctc.Tag.LINUX_PRECISE

    input_parameters = [MongoVersion] + sbt.get_script_build_params()
    execution_space = 3000

    # ScriptBuildTask fields
    tool_name = 'mongo'
    resource_type = resource_types.MONGO_PACKAGE

    def run_script(self, version, result_dir_path, env, extra_params=None):
        if 'CC' in env:
            env['PATH'] = '{0}:{1}'.format(os.path.dirname(env['CC']), env['PATH'])
        sbt.ScriptBuildTask.run_script(self, version, result_dir_path, env, extra_params)

    def on_execute(self):
        sbt.ScriptBuildTask.on_execute(self)


__Task__ = BuildMongo
