# -*- coding: utf-8 -*-

from sandbox.sandboxsdk.parameters import SandboxGitUrlParameter

from sandbox.projects import resource_types
from sandbox.projects.common.BaseBuildMonsysTask import BaseBuildMonsysTask


class MonsysDCRepositoryPath(SandboxGitUrlParameter):
    name = 'monsys_dc_repository_path'
    description = 'GIT repository with Monsys DC code'
    default_value = 'https://git.qe-infra.yandex-team.ru/scm/search-proxy/monsys-dc.git'


class BuildMonsysDC(BaseBuildMonsysTask):
    type = 'BUILD_MONSYS_DC'

    REPO_URL_PARAMETER = MonsysDCRepositoryPath
    RESOURCE_TYPE_VENV_ARCHIVE = resource_types.MONSYS_VIRTUAL_ENVIRONMENT_ARCHIVE
    WHEEL_PACKAGES = {'pycurl': '7.43.0'}

    def get_stable_services(self):
        """
        Automatically update task resources in 'production_monsys_dc' and testig services when releasing to 'stable'
        """
        return ["production_monsys_dc"] + self.get_testing_services()

    def get_testing_services(self):
        """
        Automatically update task resources in 'priemka_monsys_dc' service when releasing to 'testing'
        """
        return ["priemka_monsys_dc"]


__Task__ = BuildMonsysDC
