# -*- coding: utf-8 -*-

from sandbox.sandboxsdk.parameters import SandboxGitUrlParameter

from sandbox.projects import resource_types
from sandbox.projects.common.BaseBuildMonsysTask import BaseBuildMonsysTask


class MonsysProxyRepositoryPath(SandboxGitUrlParameter):
    name = 'monsys_proxy_repository_path'
    description = 'GIT repository with Monsys Proxy code'
    default_value = 'https://git.qe-infra.yandex-team.ru/scm/search-proxy/monsys.git'


class BuildMonsysProxy(BaseBuildMonsysTask):
    type = 'BUILD_MONSYS_PROXY'

    REPO_URL_PARAMETER = MonsysProxyRepositoryPath
    RESOURCE_TYPE_VENV_SHARD = resource_types.MONSYS_VIRTUAL_ENVIRONMENT
    WHEEL_PACKAGES = {'pycurl': '7.19.3.1'}


__Task__ = BuildMonsysProxy
