# -*- coding: utf-8 -*-
import os
import shutil

import sandbox.common.types.client as ctc

from sandbox.sandboxsdk.paths import make_folder
from sandbox.sandboxsdk.process import run_process

import sandbox.projects.common.build.parameters as build_params
from sandbox.projects import resource_types
from sandbox.projects.common.utils import svn_revision
from sandbox.projects.common.build.ArcadiaTask import ArcadiaTask


class BuildMrPacketLib(ArcadiaTask):
    """
        Build mr_packet_lib module
    """
    type = "BUILD_MR_PACKET_LIB"
    client_tags = ctc.Tag.Group.LINUX

    input_parameters = build_params.get_arcadia_params()

    secret_owner = "MR-USERS"
    secret_attr = "pypi_credentials"
    python_binary = "python2.7"
    package_source_arc_location = ["mapreduce", "library", "mr_packet_lib"]

    def _prepare_arcadia_src(self):
        arcadia_src_dir = self.get_arcadia_src_dir()
        self.ctx['arcadia_revision'] = svn_revision(arcadia_src_dir)
        return arcadia_src_dir

    def _prepare_pypirc(self, directory):
        if not os.path.isdir(directory):
            make_folder(directory)
        pypirc_data = self.get_vault_data(self.secret_owner, self.secret_attr)
        with open(os.path.join(directory, ".pypirc"), "w") as rc_prn:
            rc_prn.write(pypirc_data)

    def do_execute(self):
        arcadia_src_dir = self._prepare_arcadia_src()
        build_dir = self.path("mr_packet_lib_package")
        src_dir = os.path.join(build_dir, "mr_packet_lib")
        shutil.copytree(os.path.join(arcadia_src_dir, *self.package_source_arc_location), src_dir)

        make_folder(os.path.join(build_dir, "root"))

        run_process(
            [self.python_binary, "setup.py", "install", "--root", os.path.join(build_dir, "root")],
            log_prefix="install",
            work_dir=src_dir
        )
        self.create_resource(
            description="distribution directory",
            resource_path=os.path.join(build_dir, "root"),
            resource_type=resource_types.MR_PACKET_LIB_PACKAGE
        )


__Task__ = BuildMrPacketLib
