# -*- coding: utf-8 -*-

import os
import re

import sandbox.common.types.client as ctc

from sandbox.sandboxsdk import parameters

from sandbox.projects.common.build.BaseSimpleBuildTaskWithPkg import BaseSimpleBuildTaskWithPkg
import sandbox.projects.common.constants as consts

from sandbox.projects import resource_types
from sandbox.sandboxsdk.paths import get_logs_folder
from sandbox.sandboxsdk.svn import Arcadia


class BuildMusca(BaseSimpleBuildTaskWithPkg):
    type = 'BUILD_MUSCA'
    client_tags = ~ctc.Tag.Group.LINUX | ctc.Tag.LINUX_PRECISE

    class MuscaBinaries(parameters.SandboxInfoParameter):
        name = 'info_field2'
        description = 'Musca Binaries'

    class BuildMuscaParam(parameters.SandboxBoolParameter):
        name = 'build_musca'
        description = 'musca'

    class NewKeys(parameters.SandboxBoolParameter):
        name = 'new_keys'
        description = 'use new keys'
        default_value = True

    input_parameters = BaseSimpleBuildTaskWithPkg.input_parameters + [
        MuscaBinaries,
        BuildMuscaParam,
        NewKeys,
    ]

    TARGET_RESOURCES = (
        (resource_types.MUSCA, 'yweb/robot/musca/server/musca'),
    )

    PKG_CTX = {
        'repo_key_id': 'Robot Metrics Musca (created by luckygeck@) <robot-metrics-musca@yandex-team.ru>',
        'gpg_private_key': 'robot-metrics-musca-gpg-private',
        'gpg_public_key': 'robot-metrics-musca-gpg-public',
        'ssh_private_key': 'robot-metrics-musca-ssh',
    }

    RESOURCE_TO_PKG_MAP = {
        'linux': {
            'MUSCA': 'packages/debian/musca/yandex-search-musca-musca-bin',
        },
    }

    def initCtx(self):
        BaseSimpleBuildTaskWithPkg.initCtx(self)
        self.ctx['notify_via'] = 'email'
        self.ctx['if_failed'] = 'lamo'
        self.ctx['if_finished'] = 'lamo'

    def on_execute(self):
        if self.do_pkg_tasks_exist():
            self.check_pkg_tasks()
            return

        self.ctx[consts.ARCADIA_URL_KEY] = self.normalize_svn_url(self.ctx[consts.ARCADIA_URL_KEY])

        os.putenv('LD_LIBRARY_PATH', '')
        BaseSimpleBuildTaskWithPkg.on_execute(self)
        log_path = get_logs_folder()
        out_str = ''
        if (self.ctx['build_musca']):
            out_str += '"musca_resource_id":"%s"' % list(self.list_resources('MUSCA'))[0].id

        open(os.path.join(log_path, 'musca.id.out.txt'), "w").write(out_str)

        # Done resource creation (END)

        if self.are_pkgs_enabled():
            self.mark_resources_ready()
            if self.ctx['new_keys']:
                self.create_pkg_tasks(self.PKG_CTX)
            else:
                self.create_pkg_tasks()

    @staticmethod
    def normalize_svn_url(svn_url):
        path = Arcadia.parse_url(svn_url).path
        svn_path = re.sub(r'/arcadia.*', '/arcadia', path, count=1)
        return Arcadia.replace(svn_url, path=svn_path)


__Task__ = BuildMusca
